/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SafeBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class KeyItem
extends Item {
    public KeyItem(Item.Properties properties) {
        super(properties);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ((Enchantment)enchantment.value()).effects().has(EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (PlatHelper.getPlatform().isFabric() && context.getPlayer().isSecondaryUseActive()) {
            BlockPos pos;
            Level level = context.getLevel();
            BlockEntity tile = level.getBlockEntity(pos = context.getClickedPos());
            if (tile instanceof KeyLockableTile) {
                KeyLockableTile t = (KeyLockableTile)tile;
                if (t.tryClearingKey(context.getPlayer(), context.getItemInHand())) {
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (tile instanceof SafeBlockTile) {
                return level.getBlockState(pos).useItemOn(context.getItemInHand(), level, context.getPlayer(), context.getHand(), new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false)).result();
            }
        }
        return super.useOn(context);
    }

    public String getPassword(ItemStack stack) {
        if (stack.get(DataComponents.CUSTOM_NAME) == null) {
            return "Key";
        }
        return stack.getHoverName().getString();
    }
}

