/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public record StarItemListing(ItemCost emeralds, Optional<ItemCost> priceSecondary, int stars, int maxTrades, int xp, float priceMult, int level) implements ModItemListing
{
    public static final MapCodec<StarItemListing> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemCost.CODEC.fieldOf("price").forGetter(StarItemListing::emeralds), (App)ItemCost.CODEC.optionalFieldOf("price_secondary").forGetter(StarItemListing::priceSecondary), (App)Codec.INT.fieldOf("amount").forGetter(StarItemListing::stars), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("max_trades", (Object)16).forGetter(StarItemListing::maxTrades), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("xp").forGetter(s -> Optional.of(s.xp)), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(StarItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(StarItemListing::level)).apply((Applicative)instance, StarItemListing::createDefault));
    private static final DyeColor[] VIBRANT_COLORS = new DyeColor[]{DyeColor.WHITE, DyeColor.ORANGE, DyeColor.MAGENTA, DyeColor.LIGHT_BLUE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.PINK, DyeColor.CYAN, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.GREEN, DyeColor.RED};

    public static StarItemListing createDefault(ItemCost price, Optional<ItemCost> price2, int rockets, int maxTrades, Optional<Integer> xp, float priceMult, int level) {
        return new StarItemListing(price, price2, rockets, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)false, (int)level)), priceMult, level);
    }

    public MerchantOffer getOffer(Entity entity, RandomSource random) {
        ItemStack star = new ItemStack((ItemLike)Items.FIREWORK_STAR, this.stars);
        star.set(DataComponents.FIREWORK_EXPLOSION, (Object)StarItemListing.createRandomFireworkStar(random, List.of()));
        return new MerchantOffer(this.emeralds, this.priceSecondary, star, this.maxTrades, this.xp, this.priceMult);
    }

    public int getLevel() {
        return this.level;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    public static FireworkExplosion createRandomFireworkStar(RandomSource random, List<FireworkExplosion.Shape> usedShapes) {
        ArrayList<FireworkExplosion.Shape> possible = new ArrayList<FireworkExplosion.Shape>(List.of(FireworkExplosion.Shape.values()));
        possible.removeAll(usedShapes);
        boolean twinkle = random.nextFloat() < 0.42f;
        boolean trail = random.nextFloat() < 0.42f;
        FireworkExplosion.Shape shape = possible.isEmpty() ? FireworkExplosion.Shape.values()[random.nextInt(FireworkExplosion.Shape.values().length)] : possible.get(random.nextInt(possible.size()));
        IntArrayList colors = new IntArrayList();
        int colorCount = 0;
        do {
            colors.add(VIBRANT_COLORS[random.nextInt(VIBRANT_COLORS.length)].getFireworkColor());
        } while (random.nextFloat() < 0.42f && ++colorCount < 9);
        IntArrayList fadeColors = new IntArrayList();
        if (random.nextBoolean()) {
            colorCount = 0;
            do {
                fadeColors.add(VIBRANT_COLORS[random.nextInt(VIBRANT_COLORS.length)].getFireworkColor());
            } while (random.nextFloat() < 0.42f && ++colorCount < 9);
        }
        return new FireworkExplosion(shape, (IntList)colors, (IntList)fadeColors, trail, twinkle);
    }
}

