/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.Set;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOneUserInteractable;
import net.mehvahdjukaar.moonlight.api.block.OpenableContainerBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.FireBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IBallisticBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.CannonBallItem;
import net.mehvahdjukaar.supplementaries.common.items.components.CannonballWhitelist;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundCannonAnimationPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CannonBlockTile
extends OpenableContainerBlockTile
implements IOneUserInteractable {
    public static final int MAX_POWER_LEVEL = 4;
    public Object ccHack = null;
    @Nullable
    private Set<Block> breakWhitelist = null;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private int cooldownTimer = 0;
    private int fuseTimer = 0;
    private byte powerLevel = 1;
    private IBallisticBehavior.Data trajectoryData = IBallisticBehavior.LINE;
    private Item trajectoryFor = Items.AIR;
    @Nullable
    private UUID playerWhoIgnitedUUID = null;
    @Nullable
    private UUID controllingEntity = null;
    public final CannonAccess selfAccess = CannonAccess.block(this);

    public CannonBlockTile(BlockPos pos, BlockState blockState) {
        super(ModRegistry.CANNON_TILE.get(), pos, blockState, 2);
    }

    public CannonBlockTile(BlockPos pos, BlockState blockState, float initialYaw) {
        this(pos, blockState);
        this.yaw = initialYaw;
        this.prevYaw = initialYaw;
    }

    public void tick(CannonAccess access) {
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
        }
        if (this.fuseTimer > 0) {
            --this.fuseTimer;
            if (this.fuseTimer <= 0) {
                this.fire(access);
            }
        }
    }

    private void fire(CannonAccess access) {
        ServerLevel sl;
        if (!this.hasRequiredFuelAndProjectiles()) {
            return;
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel && this.shootProjectile(sl = (ServerLevel)level, access)) {
            access.applyRecoil();
            Player p = this.getPlayerWhoFired();
            if (p == null || !p.isCreative()) {
                ItemStack fuel = this.getFuel();
                fuel.shrink((int)this.powerLevel);
                this.setFuel(fuel);
                ItemStack projectile = this.getProjectile();
                projectile.shrink(1);
                this.setProjectile(projectile);
                this.setChanged();
                access.updateClients();
                this.level.gameEvent((Entity)p, (Holder)GameEvent.EXPLODE, access.getCannonGlobalPosition(1.0f));
            }
            NetworkHelper.sendToAllClientPlayersInRange((ServerLevel)sl, (BlockPos)BlockPos.containing((Position)access.getCannonGlobalPosition(1.0f)), (double)128.0, (CustomPacketPayload)new ClientBoundCannonAnimationPacket(access.makeNetworkTarget(), true));
        }
        this.cooldownTimer = CommonConfigs.Functional.CANNON_COOLDOWN.get();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putFloat("yaw", this.yaw);
        tag.putFloat("pitch", this.pitch);
        tag.putInt("cooldown", this.cooldownTimer);
        tag.putInt("fuse_timer", this.fuseTimer);
        tag.putByte("fire_power", this.powerLevel);
        if (this.playerWhoIgnitedUUID != null) {
            tag.putUUID("player_ignited", this.playerWhoIgnitedUUID);
        }
        if (this.breakWhitelist != null) {
            CannonBlockTile.saveBreakWhitelist(this.breakWhitelist, tag, registries);
        }
        tag.put("trajectory", (Tag)IBallisticBehavior.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.trajectoryData).getOrThrow());
    }

    public static void saveBreakWhitelist(Set<Block> breakWhitelist, CompoundTag tag, HolderLookup.Provider registries) {
        CannonballWhitelist.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)new CannonballWhitelist(breakWhitelist)).ifSuccess(t -> tag.put("break_whitelist", t));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.yaw = tag.getFloat("yaw");
        this.pitch = tag.getFloat("pitch");
        this.cooldownTimer = tag.getInt("cooldown");
        this.fuseTimer = Math.max(this.fuseTimer, tag.getInt("fuse_timer"));
        this.setPowerLevel(tag.getByte("fire_power"));
        if (tag.contains("player_ignited")) {
            this.playerWhoIgnitedUUID = tag.getUUID("player_ignited");
        }
        this.breakWhitelist = CannonBlockTile.readBreakWhitelist(tag, registries);
        if (tag.contains("trajectory")) {
            this.trajectoryData = (IBallisticBehavior.Data)IBallisticBehavior.Data.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("trajectory")).getOrThrow();
        }
    }

    private void fixRotation(Level level) {
        BlockState state = this.getBlockState();
        Rotation rot = (Rotation)state.getValue(ModBlockProperties.ROTATE_TILE);
        if (rot != Rotation.NONE && level != null && !level.isClientSide) {
            this.setYaw(this.selfAccess, this.yaw + (float)(rot.ordinal() * 90));
            level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(ModBlockProperties.ROTATE_TILE, (Comparable)Rotation.NONE));
        }
    }

    @Nullable
    public static Set<Block> readBreakWhitelist(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("break_whitelist")) {
            return CannonballWhitelist.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("break_whitelist")).result().map(CannonballWhitelist::blocks).orElse(Set.of());
        }
        return null;
    }

    public void setChanged() {
        super.setChanged();
        this.recomputeTrajectoryData();
    }

    private void computeTrajectoryData() {
        ItemStack proj = this.getProjectile();
        IFireItemBehavior behavior = FireBehaviorsManager.getCannonBehavior((ItemLike)this.getProjectile().getItem());
        if (behavior instanceof IBallisticBehavior) {
            IBallisticBehavior b = (IBallisticBehavior)behavior;
            this.trajectoryData = b.calculateData(proj, this.level);
        } else {
            this.trajectoryData = IBallisticBehavior.LINE;
        }
        if (this.trajectoryData == null) {
            Supplementaries.error();
        }
        this.trajectoryFor = proj.getItem();
    }

    public boolean readyToFire() {
        return !this.isOnCooldown() && this.fuseTimer == 0 && this.hasRequiredFuelAndProjectiles();
    }

    public boolean hasRequiredFuelAndProjectiles() {
        return !this.getProjectile().isEmpty() && !this.getFuel().isEmpty() && this.getFuel().getCount() >= this.powerLevel;
    }

    public boolean hasSomeFuelAndProjectiles() {
        return !this.getProjectile().isEmpty() && !this.getFuel().isEmpty();
    }

    public boolean isFiring() {
        return this.fuseTimer > 0;
    }

    public float getFiringAnimation(float partialTicks) {
        if (this.fuseTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.fuseTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_FUSE_TIME.get().intValue();
    }

    public boolean isOnCooldown() {
        return this.cooldownTimer > 0;
    }

    public float getCooldownAnimation(float partialTicks) {
        if (this.cooldownTimer <= 0) {
            return 0.0f;
        }
        return ((float)this.cooldownTimer - partialTicks) / (float)CommonConfigs.Functional.CANNON_COOLDOWN.get().intValue();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ItemStack getProjectile() {
        return this.getItem(1);
    }

    public void setProjectile(ItemStack stack) {
        this.setItem(1, stack);
    }

    public ItemStack getFuel() {
        return this.getItem(0);
    }

    public void setFuel(ItemStack stack) {
        this.setItem(0, stack);
    }

    public IBallisticBehavior.Data getTrajectoryData() {
        return this.trajectoryData;
    }

    private void recomputeTrajectoryData() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.trajectoryFor != this.getProjectile().getItem()) {
            this.computeTrajectoryData();
        }
    }

    public byte getPowerLevel() {
        return this.powerLevel;
    }

    public void setPowerLevel(byte powerLevel) {
        this.powerLevel = (byte)Math.clamp((long)powerLevel, 1, 4);
    }

    public float getFirePower() {
        return (float)Math.pow(this.powerLevel, CommonConfigs.Functional.CANNON_FIRE_POWER.get());
    }

    private float getStructureYaw() {
        return ((Rotation)this.getBlockState().getValue(CannonBlock.ROTATE_TILE)).ordinal() * 90;
    }

    public float getYaw(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.prevYaw, (float)this.yaw) + this.getStructureYaw();
    }

    public float getYaw() {
        return this.yaw + this.getStructureYaw();
    }

    public float getPitch(float partialTicks) {
        return Mth.rotLerp((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setAttributes(float yaw, float pitch, byte firePower, boolean fire, Player controllingPlayer, CannonAccess access) {
        this.setYaw(access, yaw);
        this.setPitch(access, pitch);
        this.setPowerLevel(firePower);
        if (fire) {
            this.ignite((Entity)controllingPlayer, access);
        }
    }

    public void setPitch(CannonAccess access, float relativePitch) {
        CannonAccess.Restraint r = access.getPitchAndYawRestrains();
        this.pitch = MthUtils.clampDegrees((float)relativePitch, (float)r.minPitch(), (float)r.maxPitch());
    }

    public void setYaw(CannonAccess access, float relativeYaw) {
        CannonAccess.Restraint r = access.getPitchAndYawRestrains();
        this.yaw = MthUtils.clampDegrees((float)relativeYaw, (float)r.minYaw(), (float)r.maxYaw()) - this.getStructureYaw();
    }

    public void setRenderYaw(CannonAccess access, float relativeYaw) {
        this.setYaw(access, relativeYaw);
        this.prevYaw = this.yaw;
    }

    public void setRenderPitch(CannonAccess access, float pitch) {
        this.setPitch(access, pitch);
        this.prevPitch = this.pitch;
    }

    protected void updateBlockState(BlockState state, boolean b) {
    }

    protected void playOpenSound(BlockState state) {
    }

    protected void playCloseSound(BlockState state) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index == 0) {
            return stack.is(Items.GUNPOWDER);
        }
        return !stack.is(ModTags.CANNON_BLACKLIST);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem(direction == null || direction.getAxis().isHorizontal() ? 1 : 0, itemStack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[]{side.getAxis().isHorizontal() ? 1 : 0};
    }

    public void ignite(@Nullable Entity entityWhoIgnited, CannonAccess access) {
        if (this.fuseTimer > 0) {
            return;
        }
        if (this.getProjectile().isEmpty()) {
            return;
        }
        this.fuseTimer = CommonConfigs.Functional.CANNON_FUSE_TIME.get();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            NetworkHelper.sendToAllClientPlayersInDefaultRange((ServerLevel)serverLevel, (BlockPos)BlockPos.containing((Position)access.getCannonGlobalPosition(1.0f)), (CustomPacketPayload)new ClientBoundCannonAnimationPacket(access.makeNetworkTarget(), false));
        }
        this.playerWhoIgnitedUUID = entityWhoIgnited != null ? entityWhoIgnited.getUUID() : null;
        this.setChanged();
        access.updateClients();
    }

    protected boolean shootProjectile(ServerLevel serverLevel, CannonAccess access) {
        Vec3 facing = access.getCannonGlobalFacing(1.0f).scale(-1.0);
        ItemStack projectile = this.getProjectile().copy();
        if (projectile.getItem() instanceof CannonBallItem && this.breakWhitelist != null) {
            projectile.set(ModComponents.CANNONBALL_WHITELIST.get(), (Object)new CannonballWhitelist(this.breakWhitelist));
        }
        IFireItemBehavior behavior = FireBehaviorsManager.getCannonBehavior((ItemLike)this.getProjectile().getItem());
        float firePower = this.getFirePower();
        return behavior.fire(projectile.copy(), serverLevel, access.getCannonGlobalPosition(1.0f), 0.5f, facing, firePower, 0, this.getPlayerWhoFired());
    }

    @Nullable
    protected Player getPlayerWhoFired() {
        UUID uuid = this.controllingEntity;
        if (uuid == null && this.playerWhoIgnitedUUID != null) {
            uuid = this.playerWhoIgnitedUUID;
        }
        if (uuid == null) {
            return null;
        }
        return this.level.getPlayerByUUID(uuid);
    }

    public void setCurrentUser(@Nullable UUID uuid) {
        this.controllingEntity = uuid;
    }

    @Nullable
    public UUID getCurrentUser() {
        return this.controllingEntity;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new CannonContainerMenu(id, inv, this.selfAccess);
    }

    public void unpackLootTable(@Nullable Player player) {
        ResourceKey resourceKey = this.getLootTable();
        super.unpackLootTable(player);
        if (resourceKey != this.getLootTable()) {
            ItemStack currentFuel;
            ItemStack currentAmmo = this.getProjectile();
            if (currentAmmo.is((currentFuel = this.getFuel()).getItem())) {
                currentFuel.setCount(currentFuel.getCount() + currentAmmo.getCount());
                currentAmmo = ItemStack.EMPTY;
            }
            if (!this.canPlaceItem(0, currentFuel) || !this.canPlaceItem(1, currentFuel)) {
                if (this.canPlaceItem(0, currentAmmo) && this.canPlaceItem(1, currentFuel)) {
                    ItemStack temp = currentAmmo;
                    currentAmmo = currentFuel;
                    currentFuel = temp;
                } else {
                    currentFuel = ItemStack.EMPTY;
                    currentAmmo = ItemStack.EMPTY;
                }
            }
            this.setFuel(currentFuel);
            this.setProjectile(currentAmmo);
        }
    }
}

