/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MovingSlidyBlockSource
extends DirectionalBlock {
    public static final MapCodec<MovingSlidyBlockSource> CODEC = MovingSlidyBlockSource.simpleCodec(MovingSlidyBlockSource::new);

    public MovingSlidyBlockSource(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends MovingSlidyBlockSource> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockState frontState = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        if (!frontState.is(ModRegistry.MOVING_SLIDY_BLOCK.get()) || frontState.getValue((Property)FACING) != state.getValue((Property)FACING)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 67);
        }
    }
}

