/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class JarredModel<T extends LivingEntity>
extends PlayerModel<T> {
    private final ModelPart eyeLeft;
    private final ModelPart eyeRight;

    public JarredModel(ModelPart modelPart) {
        super(modelPart, false);
        ModelPart head = modelPart.getChild("head");
        this.eyeLeft = head.getChild("left_eye");
        this.eyeRight = head.getChild("right_eye");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = PlayerModel.createMesh((CubeDeformation)CubeDeformation.NONE, (boolean)false);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 14.0f, 10.0f).texOffs(40, 0).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 3.0f, 6.0f).texOffs(0, 24).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 11.0f, 8.0f), PartPose.ZERO);
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(51, 1).addBox(3.9f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, true), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(46, 1).addBox(-4.9f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, false), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 10).addBox(-3.0f, -2.999f, -1.5f, 6.0f, 3.0f, 3.0f, false).texOffs(45, 12).addBox(-2.0f, -2.999f, 1.5f, 4.0f, 3.0f, 1.0f, false).texOffs(40, 16).addBox(-2.0f, 0.0f, -0.5f, 4.0f, 1.0f, 3.0f, false).texOffs(40, 20).addBox(-1.0f, 1.0f, 0.5f, 2.0f, 1.0f, 2.0f, false), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        head.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(30, 6).addBox(-3.0f, -1.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(30, 6).addBox(1.0f, 0.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void translateToHand(HumanoidArm handSide, PoseStack matrixStack) {
        matrixStack.translate(0.0, 0.8, -0.5);
        matrixStack.mulPose(RotHlpr.X90);
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        ModelPart arm = this.getArm(handSide);
        float f = 1.0f * (float)(handSide == HumanoidArm.RIGHT ? 1 : -1);
        arm.x += f;
        arm.y -= 1.0f;
        arm.z += 1.0f;
        arm.z -= 1.0f;
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, this.riding ? -0.5 : 0.5, 0.0);
        super.renderToBuffer(matrixStack, buffer, packedLight, packedOverlay, color);
        matrixStack.popPose();
    }

    public void setupAnim(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.swimAmount > 0.0f && player.isVisuallySwimming()) {
            this.body.yRot = this.rotlerpRad(limbSwing, this.body.yRot, -0.10471976f);
        }
        this.head.y = 6.0f + Mth.sin((float)(limbSwing / 3.0f)) / 2.0f;
        this.eyeRight.x = Mth.cos((float)(ageInTicks / 16.0f)) / 4.0f;
        this.eyeRight.y = Mth.sin((float)(ageInTicks / 7.0f)) / 4.0f;
        this.eyeLeft.x = Mth.cos((float)(ageInTicks / 12.0f)) / 4.0f;
        this.eyeLeft.y = Mth.cos((float)(ageInTicks / 7.0f)) / 4.0f;
    }
}

