/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.funny;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.funny.PickleData;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class JarredHeadLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final ModelPart eyeLeft;
    private final ModelPart eyeRight;
    private final ModelPart head;
    private final ModelPart model;

    public JarredHeadLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.model = entityModelSet.bakeLayer(ClientRegistry.JAR_MODEL);
        this.head = this.model.getChild("head");
        this.eyeLeft = this.head.getChild("left_eye");
        this.eyeRight = this.head.getChild("right_eye");
    }

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 44).addBox(-5.0f, -2.0f, -5.0f, 10.0f, 10.0f, 10.0f).texOffs(40, 0).addBox(-3.0f, -4.001f, -3.0f, 6.0f, 3.0f, 6.0f).texOffs(0, 24).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(42, 10).addBox(-3.0f, -2.999f, -1.5f, 6.0f, 3.0f, 3.0f, false).texOffs(45, 12).addBox(-2.0f, -2.999f, 1.5f, 4.0f, 3.0f, 1.0f, false).texOffs(40, 16).addBox(-2.0f, 0.0f, -0.5f, 4.0f, 1.0f, 3.0f, false).texOffs(40, 20).addBox(-1.0f, 1.0f, 0.5f, 2.0f, 1.0f, 2.0f, false), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        head.addOrReplaceChild("left_eye", CubeListBuilder.create().texOffs(30, 6).addBox(-3.0f, -1.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.ZERO);
        head.addOrReplaceChild("right_eye", CubeListBuilder.create().texOffs(30, 6).addBox(1.0f, 0.0f, -2.499f, 2.0f, 2.0f, 2.0f, false), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!PickleData.isActive(player.getGameProfile().getId())) {
            return;
        }
        matrixStack.pushPose();
        HumanoidModel parent = (HumanoidModel)this.getParentModel();
        ModelPart parentHead = parent.getHead();
        float bodyYRot = Mth.rotLerp((float)partialTick, (float)((Player)player).yRotO, (float)player.getYRot()) * ((float)Math.PI / 180);
        float bodyXRot = Mth.rotLerp((float)partialTick, (float)((Player)player).xRotO, (float)player.getXRot()) * ((float)Math.PI / 180);
        parentHead.translateAndRotate(matrixStack);
        float deltaTime = Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
        float viscosity = 0.17f;
        this.head.yRot = this.rotlerpRad(deltaTime * viscosity, this.head.yRot, bodyYRot + parentHead.yRot);
        this.head.xRot = this.rotlerpRad(deltaTime * viscosity, this.head.xRot, bodyXRot + parentHead.xRot);
        float k = (float)Math.PI * -2;
        this.head.yRot = -bodyYRot - parentHead.yRot + this.head.yRot + k;
        this.head.xRot = -bodyXRot - parentHead.xRot + this.head.xRot + k;
        float g = 0.875f;
        matrixStack.scale(-g, -g, g);
        matrixStack.translate(-0.5, 0.5, -0.5);
        VertexConsumer vc = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)ModTextures.JAR_MAN));
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.0f, 0.5f);
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.model.yRot = 0.0f;
        if (!(parent.swimAmount > 0.0f) || player.isVisuallySwimming()) {
            // empty if block
        }
        this.head.y = 3.5f + Mth.sin((float)(ageInTicks / 11.0f + limbSwing / 5.0f)) / 2.5f;
        this.eyeRight.x = Mth.cos((float)(ageInTicks / 16.0f)) / 4.0f;
        this.eyeRight.y = Mth.sin((float)(ageInTicks / 7.0f)) / 4.0f;
        this.eyeLeft.x = Mth.cos((float)(ageInTicks / 12.0f)) / 4.0f;
        this.eyeLeft.y = Mth.cos((float)(ageInTicks / 7.0f)) / 4.0f;
        this.model.render(matrixStack, vc, packedLight, OverlayTexture.NO_OVERLAY, -1);
        matrixStack.popPose();
        matrixStack.popPose();
        this.head.yRot += parentHead.yRot + bodyYRot - k;
        this.head.xRot += parentHead.xRot + bodyXRot - k;
    }

    protected float rotlerpRad(float angle, float maxAngle, float mul) {
        float f = (mul - maxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngle + angle * f;
    }
}

