/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import java.util.List;
import net.mehvahdjukaar.supplementaries.client.particles.DirectionOrientedBillboardParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class StreamerParticle
extends DirectionOrientedBillboardParticle {
    protected static final PerlinSimplexNoise NOISE = StreamerParticle.noise(404);
    private final int particleRandom;

    private static PerlinSimplexNoise noise(int seed) {
        return new PerlinSimplexNoise((RandomSource)new LegacyRandomSource((long)seed), List.of(Integer.valueOf(-7), Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)));
    }

    private StreamerParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.particleRandom = this.random.nextInt();
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.setSize(0.01f, 0.01f);
        this.quadSize = 0.3f;
        this.gravity = 0.21f;
        this.friction = 0.95f;
        this.lifetime = this.random.nextInt(400, 700);
    }

    public void tick() {
        boolean still = this.x == this.xo && this.z == this.zo && this.y == this.yo && this.age != 0;
        boolean hasLanded = this.onGround || still;
        float posChange = 0.003f;
        this.xd += (double)posChange * NOISE.getValue((double)this.particleRandom, (double)this.age, false);
        this.zd += (double)posChange * NOISE.getValue((double)this.particleRandom, (double)this.age, false);
        if (hasLanded) {
            this.age = Math.max(this.age, this.lifetime - 5);
        }
        super.tick();
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class DyeFactory
    implements ParticleProvider<ColorParticleOption> {
        private final SpriteSet sprite;

        public DyeFactory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(ColorParticleOption opt, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            StreamerParticle p = new StreamerParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            p.pickSprite(this.sprite);
            p.setColor(opt.getRed(), opt.getGreen(), opt.getBlue());
            return p;
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            StreamerParticle p = new StreamerParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            p.pickSprite(this.sprite);
            return p;
        }
    }
}

