/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.client.particles.DirectionOrientedBillboardParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class BombChargeParticle
extends DirectionOrientedBillboardParticle {
    private final Entity entity;

    protected BombChargeParticle(ClientLevel level, double xOff, double yOff, double zOff, Entity trackingEntity, SpriteSet sprites) {
        super(level, trackingEntity.xo + xOff, trackingEntity.yo + yOff, trackingEntity.zo + zOff);
        this.pickSprite(sprites);
        this.entity = trackingEntity;
        this.lifetime = 200;
        Vec3 sp = this.entity.getDeltaMovement();
        this.xd = sp.x;
        this.yd = sp.y;
        this.zd = sp.z;
    }

    static Vec3 position(double age, double lifetime, Vec3 center, double R0, double angularSpeed) {
        double progress = age / lifetime;
        double r = R0 * (1.0 - progress);
        double theta = angularSpeed * age;
        double x = center.x + r * Math.cos(theta);
        double y = center.y + r * Math.sin(theta);
        double z = center.z;
        return new Vec3(x, y, z);
    }

    public void tick() {
        if (this.entity == null || this.entity.isRemoved()) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        Vec3 p = BombChargeParticle.position(this.age, this.lifetime, this.entity.position(), 2.0, 0.2);
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double entityId, double a, double b) {
            Entity entity = worldIn.getEntity((int)entityId);
            if (entity != null) {
                return new BombChargeParticle(worldIn, x, y, z, entity, this.sprite);
            }
            return null;
        }
    }
}

