/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.mehvahdjukaar.supplementaries.common.entities.data.SlimedData;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Matrix4f;

public class SlimedOverlayHud
implements LayeredDraw.Layer {
    public static final SlimedOverlayHud INSTANCE = new SlimedOverlayHud();
    protected final Minecraft mc = Minecraft.getInstance();

    protected SlimedOverlayHud() {
    }

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        float alpha = SlimedData.getAlpha((LivingEntity)this.mc.player, partialTicks);
        if (alpha > 0.0f) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
            int screenHeight = graphics.guiHeight();
            int screenWidth = graphics.guiWidth();
            int slide = (int)((float)screenHeight / 3.0f * (1.0f - alpha));
            this.blit(graphics, ModTextures.SLIME_GUI_OVERLAY, 0, 0, -90, 0.0f, 0.0f, screenWidth, screenHeight + slide, screenWidth, screenHeight + slide);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void blit(GuiGraphics gui, ResourceLocation atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        this.blit(gui, atlasLocation, x, (float)x + uWidth, y, (float)y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(GuiGraphics gui, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, int blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(gui, atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + vHeight) / (float)textureHeight);
    }

    public void innerBlit(GuiGraphics gui, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = gui.pose().last().pose();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix4f, x1, y1, blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix4f, x1, y2, blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix4f, x2, y2, blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix4f, x2, y1, blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }
}

