/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container.pattern;

import appeng.api.crafting.IPatternDetails;
import com.glodblock.github.extendedae.container.pattern.ContainerPattern;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.IdentityHashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;

public class PatternGuiHandler {
    private static final Object2ObjectMap<ResourceLocation, IContainerPattern> factory = new Object2ObjectOpenHashMap();
    private static final Object2ReferenceMap<ResourceLocation, MenuType<?>> types = new Object2ReferenceOpenHashMap();
    private static final IdentityHashMap<Class<?>, ResourceLocation> patternID = new IdentityHashMap();
    private static final BiMap<Integer, ResourceLocation> internal = HashBiMap.create();
    private static int IDZ = 0;

    public static void addPatternHandler(Class<?> clazz, ResourceLocation id) {
        patternID.put(clazz, id);
    }

    public static boolean open(Player player, IPatternDetails details, ItemStack pattern) {
        Class cls = details.getClass();
        if (patternID.containsKey(cls)) {
            PatternGuiHandler.open(player, patternID.get(cls), pattern);
            return true;
        }
        return false;
    }

    public static void open(Player player, ResourceLocation id, ItemStack pattern) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        MutableComponent title = Component.translatable((String)("epp.pattern." + String.valueOf(id)));
        SimpleMenuProvider menu = new SimpleMenuProvider((wnd, p, pl) -> {
            IContainerPattern f = (IContainerPattern)factory.get((Object)id);
            MenuType t = (MenuType)types.get((Object)id);
            return f.create(t, wnd, player.level(), pattern);
        }, (Component)title);
        player.openMenu((MenuProvider)menu, buffer -> PatternGuiHandler.to(id, pattern, buffer));
    }

    private static AbstractContainerMenu from(int containerId, Inventory inv, RegistryFriendlyByteBuf packetBuf) {
        int id = packetBuf.readVarInt();
        Level world = inv.player.level();
        ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)packetBuf);
        IContainerPattern f = (IContainerPattern)factory.get(internal.get((Object)id));
        MenuType t = (MenuType)types.get(internal.get((Object)id));
        return f.create(t, containerId, world, stack);
    }

    private static void to(ResourceLocation id, ItemStack pattern, RegistryFriendlyByteBuf packetBuf) {
        packetBuf.writeVarInt(((Integer)internal.inverse().get((Object)id)).intValue());
        ItemStack.STREAM_CODEC.encode((Object)packetBuf, (Object)pattern);
    }

    public static <T extends AbstractContainerMenu> MenuType<T> register(ResourceLocation id, IContainerPattern containerFactory) {
        factory.put((Object)id, (Object)containerFactory);
        internal.put((Object)IDZ, (Object)id);
        ++IDZ;
        MenuType type = IMenuTypeExtension.create(PatternGuiHandler::from);
        types.put((Object)id, (Object)type);
        return type;
    }

    @FunctionalInterface
    public static interface IContainerPattern {
        public ContainerPattern create(MenuType<?> var1, int var2, Level var3, ItemStack var4);
    }
}

