/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.implementations.blockentities.PatternContainerGroup;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.crafting.IMolecularAssemblerSupportedPattern;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.grid.AENetworkedInvBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.CraftingThread;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.SAssemblerAnimation;
import com.glodblock.github.glodium.util.GlodUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TileExMolecularAssembler
extends AENetworkedInvBlockEntity
implements IUpgradeableObject,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final int MAX_THREAD = 8;
    private final IUpgradeInventory upgrades;
    private boolean isPowered = false;
    private final CraftingThread[] threads = new CraftingThread[8];
    private final InternalInventory internalInv;
    private final InternalInventory gridInvExt;
    private short states = 0;
    @OnlyIn(value=Dist.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public TileExMolecularAssembler(BlockPos pos, BlockState blockState) {
        super(GlodUtil.getTileType(TileExMolecularAssembler.class, TileExMolecularAssembler::new, (Block)EAESingletons.EX_ASSEMBLER), pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.upgrades = UpgradeInventories.forMachine((ItemLike)EAESingletons.EX_ASSEMBLER, (int)this.getUpgradeSlots(), () -> ((TileExMolecularAssembler)this).saveChanges());
        ArrayList<InternalInventory> invs = new ArrayList<InternalInventory>();
        ArrayList<InternalInventory> invs2 = new ArrayList<InternalInventory>();
        int x = 0;
        while (x < 8) {
            int index = x++;
            this.threads[index] = new CraftingThread((AEBaseBlockEntity)this, signal -> this.changeState(index, signal));
            invs.add(this.threads[index].getInternalInventory());
            invs2.add(this.threads[index].getExposedInventoryForSide());
        }
        this.internalInv = new CombinedInternalInventory(invs.toArray(new InternalInventory[0]));
        this.gridInvExt = new CombinedInternalInventory(invs2.toArray(new InternalInventory[0]));
    }

    private void changeState(int index, boolean state) {
        boolean oldState = this.states > 0;
        this.states = state ? (short)(this.states | 1 << index) : (short)(this.states & ~(1 << index));
        if (state) {
            if (!oldState) {
                this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
            }
        } else if (oldState && this.states <= 0) {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
    }

    public int getUpgradeSlots() {
        return 5;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    public PatternContainerGroup getCraftingMachineInfo() {
        Component name = this.hasCustomName() ? this.getCustomName() : EAESingletons.EX_ASSEMBLER.asItem().getDescription();
        AEItemKey icon = AEItemKey.of((ItemLike)EAESingletons.EX_ASSEMBLER);
        int accelerationCards = this.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        List<Object> tooltip = accelerationCards == 0 ? List.of() : List.of(GuiText.CompatibleUpgrade.text(new Object[]{Tooltips.of((Component)AEItems.SPEED_CARD.asItem().getDescription()), Tooltips.ofUnformattedNumber((long)accelerationCards)}));
        return new PatternContainerGroup(icon, name, tooltip);
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputs, Direction ejectionDirection) {
        for (CraftingThread thread : this.threads) {
            if (!thread.acceptJob(patternDetails, inputs, ejectionDirection)) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsPlans() {
        return true;
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        super.saveAdditional(data, registries);
        for (int x = 0; x < 8; ++x) {
            CompoundTag tag = this.threads[x].writeNBT(registries);
            data.put("#ct" + x, (Tag)tag);
        }
        this.upgrades.writeToNBT(data, "upgrades", registries);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        super.loadTag(data, registries);
        this.upgrades.readFromNBT(data, "upgrades", registries);
        for (int x = 0; x < 8; ++x) {
            if (!data.contains("#ct" + x)) continue;
            this.threads[x].readNBT(data.getCompound("#ct" + x), registries);
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        if (id.equals((Object)MolecularAssemblerBlockEntity.INV_MAIN)) {
            return this.internalInv;
        }
        return super.getSubInventory(id);
    }

    public InternalInventory getCraftInventory(int index) {
        return this.threads[index].getInternalInventory();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        boolean isAwake = false;
        for (CraftingThread t : this.threads) {
            t.recalculatePlan();
            t.updateSleepiness();
            isAwake |= t.isAwake();
        }
        return new TickingRequest(1, 1, !isAwake);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation rate = TickRateModulation.SLEEP;
        ItemStack firstJob = ItemStack.EMPTY;
        int cards = this.upgrades.getInstalledUpgrades((ItemLike)AEItems.SPEED_CARD);
        for (CraftingThread t : this.threads) {
            if (!t.isAwake()) continue;
            TickRateModulation tr = t.tick(cards, ticksSinceLastCall);
            if (tr.ordinal() > rate.ordinal()) {
                rate = tr;
            }
            if (!firstJob.isEmpty()) continue;
            firstJob = t.getOutput();
        }
        AEItemKey item = AEItemKey.of((ItemStack)firstJob);
        if (item != null && this.level instanceof ServerLevel) {
            EAENetworkHandler.INSTANCE.sendToAllAround(new SAssemblerAnimation(this.worldPosition, 50, (AEKey)item), (ServerLevel)this.level, this.worldPosition, 32.0, null);
        }
        return rate;
    }

    public InternalInventory getInternalInventory() {
        return this.internalInv;
    }

    protected InternalInventory getExposedInventoryForSide(Direction side) {
        return this.gridInvExt;
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        for (CraftingThread t : this.threads) {
            if (inv != t.getInternalInventory()) continue;
            t.recalculatePlan();
            break;
        }
    }

    public int getCraftingProgress(int index) {
        return this.threads[index].getCraftingProgress();
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public void clearContent() {
        super.clearContent();
        this.upgrades.clear();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            boolean newState = false;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                boolean bl = newState = this.getMainNode().isPowered() && grid.getEnergyService().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
            }
            if (newState != this.isPowered) {
                this.isPowered = newState;
                this.markForUpdate();
            }
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public IMolecularAssemblerSupportedPattern getCurrentPattern(int index) {
        return this.threads[index].getCurrentPattern();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }
}

