/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.me.wireless;

import appeng.api.features.Locatables;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.me.service.helpers.ConnectionWrapper;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.common.me.FreqGenerator;
import com.glodblock.github.extendedae.common.me.wireless.WirelessNode;
import com.glodblock.github.extendedae.config.EAEConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.Nullable;

public class WirelessConnect
implements IActionHost {
    public static final FreqGenerator<Long> G = FreqGenerator.createLong();
    private static final Locatables.Type<WirelessConnect> CONNECTORS = new Locatables.Type();
    private boolean isDestroyed = false;
    private boolean registered;
    private ConnectionWrapper connection;
    private long thisSide;
    private long otherSide;
    private boolean shutdown;
    private double dis;
    private WirelessNode host;

    public WirelessConnect(WirelessNode connector) {
        this.host = connector;
        this.registered = true;
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onUnload(LevelEvent.Unload e) {
        if (this.host != null && this.host.getLevel() == e.getLevel()) {
            this.destroy();
        }
    }

    public void active() {
        NeoForge.EVENT_BUS.register((Object)this);
        this.registered = true;
    }

    public void updateStatus() {
        long f = this.host.getFrequency();
        if (this.thisSide != f && this.thisSide != -f) {
            if (f != 0L) {
                if (this.thisSide != 0L) {
                    CONNECTORS.unregister(this.host.getLevel(), this.thisSide);
                }
                if (this.canUseNode(-f)) {
                    this.otherSide = f;
                    this.thisSide = -f;
                } else if (this.canUseNode(f)) {
                    this.thisSide = f;
                    this.otherSide = -f;
                }
                CONNECTORS.register(this.host.getLevel(), this.getLocatableKey(), (Object)this);
            } else {
                CONNECTORS.unregister(this.host.getLevel(), this.getLocatableKey());
                this.otherSide = 0L;
                this.thisSide = 0L;
            }
        }
        WirelessConnect sideB = this.otherSide == 0L ? null : (WirelessConnect)CONNECTORS.get(this.host.getLevel(), this.otherSide);
        this.shutdown = false;
        this.dis = 0.0;
        if (sideB != null) {
            WirelessConnect sideA = this;
            this.dis = Math.sqrt(sideA.host.getBlockPos().distSqr((Vec3i)sideB.host.getBlockPos()));
            if (sideA.isActive() && sideB.isActive() && this.dis <= EAEConfig.wirelessMaxRange && sideA.host.getLevel() == sideB.host.getLevel()) {
                if (this.connection != null && this.connection.getConnection() != null) {
                    IGridNode a = this.connection.getConnection().a();
                    IGridNode b = this.connection.getConnection().b();
                    IGridNode sa = sideA.getNode();
                    IGridNode sb = sideB.getNode();
                    if (!(a != sa && b != sa || a != sb && b != sb)) {
                        return;
                    }
                }
                try {
                    if (sideA.connection != null && sideA.connection.getConnection() != null) {
                        sideA.connection.getConnection().destroy();
                        sideA.connection = new ConnectionWrapper(null);
                    }
                    if (sideB.connection != null && sideB.connection.getConnection() != null) {
                        sideB.connection.getConnection().destroy();
                        sideB.connection = new ConnectionWrapper(null);
                    }
                    if (sideA.getNode() != null && sideB.getNode() != null) {
                        sideA.connection = sideB.connection = new ConnectionWrapper(GridHelper.createConnection((IGridNode)sideA.getNode(), (IGridNode)sideB.getNode()));
                    }
                }
                catch (IllegalStateException e) {
                    ExtendedAE.LOGGER.debug(e.getMessage());
                }
            } else {
                this.shutdown = true;
            }
        } else {
            this.shutdown = true;
        }
        if (this.shutdown && this.connection != null && this.connection.getConnection() != null) {
            this.connection.getConnection().destroy();
            this.connection.setConnection(null);
            this.connection = new ConnectionWrapper(null);
        }
    }

    public double getDistance() {
        return this.dis;
    }

    public boolean isConnected() {
        return !this.shutdown;
    }

    private boolean canUseNode(long qe) {
        WirelessConnect qc = (WirelessConnect)CONNECTORS.get(this.host.getLevel(), qe);
        if (qc != null) {
            Level world = qc.host.getLevel();
            if (!qc.isDestroyed && world != null) {
                if (world.hasChunkAt(qc.host.getBlockPos())) {
                    ServerLevel cur = Objects.requireNonNull(world.getServer()).getLevel(world.dimension());
                    BlockEntity te = world.getBlockEntity(qc.host.getBlockPos());
                    return te != qc.host.getBlockEntity() || world != cur;
                }
                ExtendedAE.LOGGER.warn(String.format("Found a registered Wireless Connector with serial %s whose chunk seems to be unloaded: %s", qe, qc));
            }
        }
        return true;
    }

    @Nullable
    public BlockPos getOtherSide() {
        BlockPos blockPos;
        if (this.otherSide == 0L) {
            return null;
        }
        WirelessConnect o = (WirelessConnect)CONNECTORS.get(this.host.getLevel(), this.otherSide);
        if (o instanceof WirelessConnect) {
            WirelessConnect c = o;
            blockPos = c.host.getBlockPos();
        } else {
            blockPos = null;
        }
        return blockPos;
    }

    private boolean isActive() {
        if (this.isDestroyed || !this.registered) {
            return false;
        }
        return this.hasFreq();
    }

    private IGridNode getNode() {
        return this.host.getGridNode();
    }

    private boolean hasFreq() {
        return this.thisSide != 0L;
    }

    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        this.shutdown = true;
        try {
            if (this.registered) {
                NeoForge.EVENT_BUS.unregister((Object)this);
                this.registered = false;
            }
            if (this.thisSide != 0L) {
                this.updateStatus();
                CONNECTORS.unregister(this.host.getLevel(), this.getLocatableKey());
            }
            this.host = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long getLocatableKey() {
        return this.thisSide;
    }

    public IGridNode getActionableNode() {
        return this.host.getGridNode();
    }
}

