/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.parts.PartItem;
import com.glodblock.github.extendedae.common.parts.PartSmartAnnihilationPlane;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ItemSmartAnnihilationPlane
extends PartItem<PartSmartAnnihilationPlane> {
    public static final ThreadLocal<Object> CALLING_DAMAGEABLE_FROM_ANVIL = ThreadLocal.withInitial(() -> null);

    public ItemSmartAnnihilationPlane() {
        super(new Item.Properties(), PartSmartAnnihilationPlane.class, PartSmartAnnihilationPlane::new);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return CALLING_DAMAGEABLE_FROM_ANVIL.get() != null ? 1 : super.getMaxDamage(stack);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> lines, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, context, lines, isAdvanced);
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (enchantments.isEmpty()) {
            lines.add((Component)Tooltips.of((GuiText)GuiText.CanBeEnchanted, (Object[])new Object[0]));
        } else {
            lines.add((Component)Tooltips.of((GuiText)GuiText.IncreasedEnergyUseFromEnchants, (Object[])new Object[0]));
        }
    }

    public void addToMainCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        super.addToMainCreativeTab(parameters, output);
        HolderLookup.RegistryLookup enchantmentRegistry = parameters.holders().lookupOrThrow(Registries.ENCHANTMENT);
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantments.set((Holder)enchantmentRegistry.getOrThrow(Enchantments.SILK_TOUCH), 1);
        ItemStack silkTouch = new ItemStack((ItemLike)this);
        silkTouch.set(DataComponents.ENCHANTMENTS, (Object)enchantments.toImmutable());
        output.accept(silkTouch);
    }
}

