/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.items.AEBaseItem;
import appeng.items.storage.StorageCellTooltipComponent;
import com.glodblock.github.extendedae.util.LazyInits;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class ItemInfinityCell
extends AEBaseItem {
    private AEKey record;

    public ItemInfinityCell(@NotNull Supplier<AEKey> type) {
        super(new Item.Properties().stacksTo(1));
        LazyInits.addFinal(() -> {
            this.record = (AEKey)type.get();
        });
    }

    public ItemInfinityCell(@NotNull Supplier<AEKey> type, Item.Properties properties) {
        super(properties);
        LazyInits.addFinal(() -> {
            this.record = (AEKey)type.get();
        });
    }

    public AEKey getRecord() {
        return this.record;
    }

    @NotNull
    public Component getName(@NotNull ItemStack is) {
        return Component.translatable((String)"item.extendedae.infinity_cell_name", (Object[])new Object[]{this.record.getDisplayName()});
    }

    public void appendHoverText(@NotNull ItemStack is, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext ctx, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        lines.add((Component)Component.translatable((String)"infinity.tooltip").withStyle(ChatFormatting.GREEN));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        List<GenericStack> content = Collections.singletonList(new GenericStack(this.record, ItemInfinityCell.getAsIntMax(this.record)));
        return Optional.of(new StorageCellTooltipComponent(List.of(), content, false, true));
    }

    public static long getAsIntMax(AEKey key) {
        return Integer.MAX_VALUE * (long)key.getAmountPerUnit();
    }
}

