/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.blocks;

import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.blocks.BlockBaseGui;
import com.glodblock.github.extendedae.common.me.wireless.WirelessFail;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessConnector;
import com.glodblock.github.extendedae.common.tileentities.TileWirelessHub;
import com.glodblock.github.extendedae.config.EAEConfig;
import com.glodblock.github.extendedae.container.ContainerWirelessConnector;
import it.unimi.dsi.fastutil.Pair;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockWirelessConnector
extends BlockBaseGui<TileWirelessConnector> {
    private static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    private static final IntegerProperty COLOR = IntegerProperty.create((String)"color", (int)0, (int)16);

    public BlockWirelessConnector() {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)COLOR, (Comparable)Integer.valueOf(16)));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED});
        builder.add(new Property[]{COLOR});
    }

    protected BlockState updateBlockStateFromBlockEntity(BlockState currentState, TileWirelessConnector be) {
        return (BlockState)((BlockState)currentState.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(be.isConnected()))).setValue((Property)COLOR, (Comparable)Integer.valueOf(be.getColor().ordinal()));
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        TileWirelessConnector te = (TileWirelessConnector)this.getBlockEntity((BlockGetter)level, pos);
        if (te != null) {
            te.reactive();
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != state.getBlock()) {
            TileWirelessConnector te = (TileWirelessConnector)this.getBlockEntity((BlockGetter)level, pos);
            if (te != null) {
                te.breakOnRemove();
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public ItemInteractionResult check(TileWirelessConnector tile, ItemStack stack, Level world, BlockPos thisPos, BlockHitResult hit, Player p) {
        if (stack.getItem() == EAESingletons.WIRELESS_TOOL && world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            Pair locator = (Pair)stack.get(EAESingletons.WIRELESS_LOCATOR);
            if (locator != null) {
                Long f = (Long)locator.left();
                GlobalPos globalPos = (GlobalPos)locator.right();
                if (f != 0L) {
                    if (globalPos == null) {
                        p.displayClientMessage(WirelessFail.MISSING.getTranslation(), true);
                        return ItemInteractionResult.FAIL;
                    }
                    BlockPos otherPos = globalPos.pos();
                    ResourceKey otherWorld = globalPos.dimension();
                    ResourceKey thisWorld = world.dimension();
                    if (otherPos.equals((Object)thisPos) && otherWorld.equals(thisWorld)) {
                        p.displayClientMessage(WirelessFail.SELF_REFERENCE.getTranslation(), true);
                        return ItemInteractionResult.FAIL;
                    }
                    if (!otherWorld.equals(thisWorld)) {
                        p.displayClientMessage(WirelessFail.CROSS_DIMENSION.getTranslation(), true);
                        return ItemInteractionResult.FAIL;
                    }
                    if (Math.sqrt(otherPos.distSqr((Vec3i)thisPos)) > EAEConfig.wirelessMaxRange) {
                        p.displayClientMessage(WirelessFail.OUT_OF_RANGE.getTranslation(), true);
                        return ItemInteractionResult.FAIL;
                    }
                    ServerLevel otherWorldInstance = server.getServer().getLevel(otherWorld);
                    if (otherWorldInstance == null) {
                        p.displayClientMessage(WirelessFail.MISSING.getTranslation(), true);
                        return ItemInteractionResult.FAIL;
                    }
                    BlockEntity otherTile = otherWorldInstance.getBlockEntity(otherPos);
                    if (otherTile instanceof TileWirelessConnector) {
                        TileWirelessConnector otherConnector = (TileWirelessConnector)otherTile;
                        otherConnector.setFrequency(f);
                        tile.setFrequency(f);
                        stack.remove(EAESingletons.WIRELESS_LOCATOR);
                        p.displayClientMessage((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()}), true);
                        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
                    }
                    if (otherTile instanceof TileWirelessHub) {
                        TileWirelessHub otherHub = (TileWirelessHub)otherTile;
                        int port = otherHub.allocatePort();
                        if (port < 0) {
                            p.displayClientMessage(WirelessFail.OUT_OF_PORT.getTranslation(), true);
                            return ItemInteractionResult.FAIL;
                        }
                        otherHub.setFrequency(f, port);
                        tile.setFrequency(f);
                        stack.remove(EAESingletons.WIRELESS_LOCATOR);
                        p.displayClientMessage((Component)Component.translatable((String)"chat.wireless_connect", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()}), true);
                        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
                    }
                    p.displayClientMessage(WirelessFail.MISSING.getTranslation(), true);
                    return ItemInteractionResult.FAIL;
                }
            }
            long freq = tile.getNewFreq();
            GlobalPos globalPos = GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)thisPos);
            stack.set(EAESingletons.WIRELESS_LOCATOR, (Object)Pair.of((Object)freq, (Object)globalPos));
            p.displayClientMessage((Component)Component.translatable((String)"chat.wireless_bind", (Object[])new Object[]{thisPos.getX(), thisPos.getY(), thisPos.getZ()}), true);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return null;
    }

    @Override
    public void openGui(TileWirelessConnector tile, Player p) {
        MenuOpener.open(ContainerWirelessConnector.TYPE, (Player)p, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)tile));
    }
}

