/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.api;

import appeng.api.config.CondenserOutput;
import appeng.core.definitions.AEItems;
import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public enum VoidMode implements StringRepresentable
{
    TRASH((ItemLike)Items.AIR),
    MATTER_BALLS((ItemLike)AEItems.MATTER_BALL),
    SINGULARITY((ItemLike)AEItems.SINGULARITY);

    public final ItemLike output;
    public static final Codec<VoidMode> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, VoidMode> STREAM_CODEC;

    private VoidMode(ItemLike output) {
        this.output = output;
    }

    public int getPower() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CondenserOutput.TRASH.requiredPower;
            case 1 -> CondenserOutput.MATTER_BALLS.requiredPower;
            case 2 -> CondenserOutput.SINGULARITY.requiredPower;
        };
    }

    @NotNull
    public String getSerializedName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(VoidMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(VoidMode.class);
    }
}

