/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.little_big_redstone.network.packet.UpdateMicrochipWatcherPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record RequestMicrochipWatcherPacket(BlockPos pos, boolean start) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, RequestMicrochipWatcherPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RequestMicrochipWatcherPacket::pos, (StreamCodec)ByteBufCodecs.BOOL, RequestMicrochipWatcherPacket::start, RequestMicrochipWatcherPacket::new);

    public void handle(PacketContext context) {
        BlockEntity blockEntity;
        context.assertServerbound();
        if (this.start && (blockEntity = context.getPlayer().level().getBlockEntity(this.pos)) instanceof MicrochipBlockEntity) {
            MicrochipBlockEntity microchipBlockEntity = (MicrochipBlockEntity)blockEntity;
            new UpdateMicrochipWatcherPacket(microchipBlockEntity.microchip()).sendToClient((ServerPlayer)context.getPlayer());
            context.getPlayer().setWatchedMicrochip(this.pos);
        } else {
            context.getPlayer().setWatchedMicrochip(null);
        }
    }
}

