/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.note;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainer;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;

public final class MicrochipStickyNotes
extends MicrochipObjectContainer<StickyNoteEntry, MicrochipStickyNotes> {
    public static final Codec<MicrochipStickyNotes> CODEC = Codec.list(StickyNoteEntry.CODEC).xmap(MicrochipStickyNotes::new, MicrochipObjectContainer::values);
    public static final StreamCodec<ByteBuf, MicrochipStickyNotes> STREAM_CODEC = StickyNoteEntry.STREAM_CODEC.apply(ByteBufCodecs.list()).map(MicrochipStickyNotes::new, MicrochipObjectContainer::values);

    private MicrochipStickyNotes(Microchip microchip, List<StickyNoteEntry> notes) {
        super(microchip, notes);
    }

    private MicrochipStickyNotes(List<StickyNoteEntry> notes) {
        this((Microchip)null, notes);
    }

    public MicrochipStickyNotes(Microchip microchip) {
        this(microchip, Lists.newArrayList());
    }

    private StickyNoteEntry add(int x, int y, DyeColor color, StickyNote note, DyeColor textColor) {
        int slot = this.pickAvailableSlot();
        StickyNoteEntry entry = new StickyNoteEntry(slot, x, y, color, note, textColor);
        if (this.microchip.canFit(entry.toBounds())) {
            this.objects.put(slot, entry);
            return entry;
        }
        return null;
    }

    public StickyNoteEntry add(int x, int y, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof StickyNoteItem) {
            StickyNoteItem stickyNote = (StickyNoteItem)item;
            DyeColor color = stickyNote.color();
            StickyNote note = (StickyNote)stack.get(LBRComponents.STICKY_NOTE);
            DyeColor textColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
            return this.add(x, y, color, note, textColor);
        }
        return null;
    }

    public void remove(int slot) {
        this.objects.remove(slot);
    }

    public void remove(StickyNoteEntry entry) {
        this.remove(entry.slot());
    }

    @Override
    public MicrochipStickyNotes with(Microchip microchip) {
        MicrochipStickyNotes notes = new MicrochipStickyNotes(microchip);
        notes.loadFrom(this);
        return notes;
    }

    @Override
    public void loadFrom(MicrochipStickyNotes other) {
        this.objects = Maps.newHashMap((Map)other.objects);
    }

    @Override
    public int hashCode() {
        return this.objects.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MicrochipStickyNotes)) return false;
        MicrochipStickyNotes other = (MicrochipStickyNotes)o;
        if (this.hashCode() != other.hashCode()) return false;
        return true;
    }
}

