/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.randomizer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.tesseract.neoforge.api.range.IntRange;

public final class LogicRandomizerConfig
extends LogicConfig<LogicRandomizerConfig> {
    public static final MapCodec<LogicRandomizerConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)10).optionalFieldOf("outputs", (Object)1).forGetter(config -> config.outputs), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.chance))).apply((Applicative)instance, LogicRandomizerConfig::new));
    public static final StreamCodec<ByteBuf, LogicRandomizerConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, config -> config.outputs, (StreamCodec)ByteBufCodecs.FLOAT, config -> Float.valueOf(config.chance), LogicRandomizerConfig::new);
    public int outputs;
    public float chance;

    private LogicRandomizerConfig(int outputs, float chance) {
        this.outputs = outputs;
        this.chance = chance;
    }

    public LogicRandomizerConfig() {
        this(1, 1.0f);
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicConfigTooltipOutputs(this.outputs));
        lines.add((Component)LBR.text().logicConfigTooltipChance(this.chance));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addSlider((Component)LBR.text().logicConfigButtonLabelOutputs(), (Component)Component.empty(), (Component)LBR.text().logicConfigButtonTooltipOutputs(), 0, 0, width, 18, this.outputsAllowed().min(), this.outputsAllowed().max(), this.outputs, 1.0, 0, value -> {
            this.outputs = value.intValue();
        });
        builder.addSlider((Component)LBR.text().logicConfigButtonLabelChance(), (Component)Component.literal((String)"%"), (Component)LBR.text().logicConfigButtonTooltipRandomizerChance(), 0, 22, width, 18, 1.0, 100.0, this.chance * 100.0f, 1.0, 0, value -> {
            this.chance = (float)(value / 100.0);
        });
    }

    @Override
    protected void internalLoadFrom(LogicRandomizerConfig other) {
        this.outputs = other.outputs;
        this.chance = other.chance;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int inputs() {
        return 1;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 10);
    }

    @Override
    public int outputs() {
        return this.outputs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.outputs, Float.valueOf(this.chance));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicRandomizerConfig)) return false;
        LogicRandomizerConfig other = (LogicRandomizerConfig)o;
        if (this.outputs != other.outputs) return false;
        if (this.chance != other.chance) return false;
        return true;
    }
}

