/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.gate;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.gate.LogicGate;
import net.swedz.little_big_redstone.microchip.object.logic.gate.config.MultiLogicGateConfig;

public final class ANDGate
extends LogicGate<ANDGate, MultiLogicGateConfig> {
    public static final MapCodec<ANDGate> CODEC = ANDGate.mapCodec(MultiLogicGateConfig.CODEC, ANDGate::new);
    public static final StreamCodec<ByteBuf, ANDGate> STREAM_CODEC = ANDGate.streamCodec(MultiLogicGateConfig.STREAM_CODEC, ANDGate::new);

    private ANDGate(MultiLogicGateConfig config, Optional<DyeColor> color, boolean outputState) {
        super(config, color, outputState);
    }

    private ANDGate(Optional<DyeColor> color, boolean outputState) {
        super(color, outputState);
    }

    public ANDGate() {
        this(Optional.empty(), false);
    }

    @Override
    protected MultiLogicGateConfig defaultConfig() {
        return new MultiLogicGateConfig();
    }

    @Override
    public LogicType<ANDGate> type() {
        return LogicTypes.AND;
    }

    @Override
    public boolean processInputs(LogicContext context, boolean[] inputs) {
        for (boolean input : inputs) {
            if (input) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appendNoShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicGateAlgebra((Component)LBR.text().logicGateAlgebraAND()));
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicHelpANDGate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.config, this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ANDGate)) return false;
        ANDGate other = (ANDGate)o;
        if (!Objects.equals(this.config, other.config)) return false;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

