/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.wire.Wire;

public final class LogicTraversal {
    public static List<LogicEntry> buildOrder(Microchip microchip) {
        ArrayList order = Lists.newArrayList();
        HashSet wiresUsed = Sets.newHashSet();
        ArrayList starts = Lists.newArrayList();
        for (LogicEntry entry : microchip.components()) {
            if (entry.component().inputs() != 0 && !microchip.wires().getByInputSlot(entry.slot()).isEmpty()) continue;
            order.add(entry);
            starts.add(entry);
        }
        for (LogicEntry entry : starts) {
            LogicTraversal.recursivelyBuildOrder(microchip, entry, order, wiresUsed);
        }
        HashSet touched = Sets.newHashSet();
        ArrayList finalOrder = Lists.newArrayList();
        for (int i = order.size() - 1; i >= 0; --i) {
            LogicEntry entry = (LogicEntry)order.get(i);
            if (!touched.add(entry)) continue;
            finalOrder.addFirst(entry);
        }
        return Collections.unmodifiableList(finalOrder);
    }

    private static void recursivelyBuildOrder(Microchip microchip, LogicEntry entry, List<LogicEntry> order, Set<Wire> wiresUsed) {
        ArrayList toBuild = Lists.newArrayList();
        for (Wire wire : microchip.wires().getByOutputSlot(entry.slot())) {
            LogicEntry targetEntry;
            if (!wiresUsed.add(wire) || (targetEntry = (LogicEntry)microchip.components().get(wire.input().slot())) == null) continue;
            int existingTargetIndex = order.indexOf(targetEntry);
            if (existingTargetIndex >= 0) {
                if (LogicTraversal.hasChild(microchip, targetEntry, true, targetEntry)) continue;
                microchip.wires().getByOutputSlot(targetEntry.slot()).forEach(wiresUsed::remove);
            }
            order.add(targetEntry);
            toBuild.add(targetEntry);
        }
        for (LogicEntry targetEntry : toBuild) {
            LogicTraversal.recursivelyBuildOrder(microchip, targetEntry, order, wiresUsed);
        }
    }

    private static boolean hasChild(Microchip microchip, LogicEntry entry, boolean recursive, LogicEntry search) {
        return LogicTraversal.hasChild(microchip, entry, recursive, search, Sets.newLinkedHashSet());
    }

    private static boolean hasChild(Microchip microchip, LogicEntry entry, boolean recursive, LogicEntry search, Set<LogicEntry> children) {
        LinkedHashSet found = Sets.newLinkedHashSet();
        for (Wire wire : microchip.wires().getByOutputSlot(entry.slot())) {
            LogicEntry childEntry = (LogicEntry)microchip.components().get(wire.input().slot());
            if (childEntry == search) {
                return true;
            }
            if (!children.add(childEntry)) continue;
            found.add(childEntry);
        }
        if (recursive) {
            for (LogicEntry childEntry : found) {
                if (!LogicTraversal.hasChild(microchip, childEntry, true, search, children)) continue;
                return true;
            }
        }
        return false;
    }
}

