/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip.element;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.guide.LBRGuide;
import net.swedz.little_big_redstone.guide.tags.microchip.MicrochipGuidebookScene;
import net.swedz.little_big_redstone.guide.tags.microchip.element.MicrochipSceneElementTagCompiler;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;

public final class LogicElementTagCompiler
implements MicrochipSceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("Logic");
    }

    @Override
    public void compile(MicrochipGuidebookScene microchip, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        String name = MdxAttrs.getString((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"name", null);
        if (name == null) {
            errorSink.appendError(compiler, "No name provided for logic element", (UnistNode)el);
            return;
        }
        if (microchip.getLogicSlot(name) != null) {
            errorSink.appendError(compiler, "Logic element already exists for that name", (UnistNode)el);
            return;
        }
        int x = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"x", (int)0);
        int y = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"y", (int)0);
        DyeColor color = LBRGuide.getDyeColor(compiler, errorSink, el, "color", null);
        LogicType<?> type = LBRGuide.getLogicType(compiler, errorSink, el, "type");
        if (type == null) {
            return;
        }
        CompoundTag data = MdxAttrs.getCompoundTag((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"data", (CompoundTag)new CompoundTag());
        if (!data.contains("config")) {
            data.put("config", (Tag)new CompoundTag());
        }
        boolean hide = MdxAttrs.getBoolean((PageCompiler)compiler, (LytErrorSink)errorSink, (MdxJsxElementFields)el, (String)"hide", (boolean)false);
        microchip.addLogic(name, x, y, color, type, data, hide, compiler, errorSink, el);
    }
}

