/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.block;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BoxFlowDirection;
import guideme.compiler.tags.FlowTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.flow.InlineBlockAlignment;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowInlineBlock;
import guideme.document.flow.LytFlowParent;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.unist.UnistNode;
import java.util.Set;
import net.swedz.little_big_redstone.guide.tags.block.LytSizedHBox;
import net.swedz.little_big_redstone.guide.tags.block.LytSizedVBox;

public final class FloatingBoxTagCompiler
extends FlowTagCompiler {
    private final BoxFlowDirection direction;

    public FloatingBoxTagCompiler(BoxFlowDirection direction) {
        this.direction = direction;
    }

    public Set<String> getTagNames() {
        return Set.of(this.direction == BoxFlowDirection.ROW ? "FloatingRow" : "FloatingColumn");
    }

    protected void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        int gap = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"gap", (int)5);
        String align = el.getAttributeString("align", "left");
        int width = MdxAttrs.getInt((PageCompiler)compiler, (LytErrorSink)parent, (MdxJsxElementFields)el, (String)"width", (int)-1);
        Object box = switch (this.direction) {
            default -> throw new MatchException(null, null);
            case BoxFlowDirection.ROW -> new LytSizedHBox(width);
            case BoxFlowDirection.COLUMN -> new LytSizedVBox(width);
        };
        box.setGap(gap);
        LytFlowInlineBlock inlineBlock = LytFlowInlineBlock.of((LytBlock)box);
        switch (align) {
            case "left": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_LEFT);
                break;
            }
            case "right": {
                inlineBlock.setAlignment(InlineBlockAlignment.FLOAT_RIGHT);
                break;
            }
            default: {
                parent.append(compiler.createErrorFlowContent("Invalid align. Must be left or right.", (UnistNode)el));
            }
        }
        compiler.compileBlockContext(el.children(), (LytBlockContainer)box);
        parent.append((LytFlowContent)inlineBlock);
    }
}

