/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.logic;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRendererProvider;
import net.swedz.little_big_redstone.gui.microchip.logic.renderer.IORenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.renderer.OnOffLogicRenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.renderer.SequencerRenderer;
import net.swedz.little_big_redstone.gui.microchip.logic.renderer.SimpleLogicRenderer;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class LogicRenderers {
    private static final Map<LogicType<?>, LogicRendererProvider<?>> PROVIDERS = Maps.newConcurrentMap();
    private static Map<LogicType<?>, LogicRenderer<?>> RENDERERS = Map.of();

    public static void init() {
        RENDERERS = LogicRenderers.createRenderers();
    }

    private static <L extends LogicComponent> void register(LogicType<L> type, LogicRendererProvider<L> provider) {
        PROVIDERS.put(type, provider);
    }

    private static Map<LogicType<?>, LogicRenderer<?>> createRenderers() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PROVIDERS.forEach((type, provider) -> {
            try {
                builder.put(type, provider.create());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to create logic renderer for " + type.id(), ex);
            }
        });
        return builder.build();
    }

    public static <L extends LogicComponent> void render(LogicRenderer.Context context, TesseractGuiGraphics graphics, L component, int x, int y) {
        LogicRenderer<?> renderer = RENDERERS.get(component.type());
        if (renderer != null) {
            renderer.render(context, graphics, component, x, y);
        }
    }

    static {
        LogicRenderers.register(LogicTypes.DEBUGGER, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.IO, IORenderer::new);
        LogicRenderers.register(LogicTypes.NOT, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.AND, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.NAND, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.OR, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.NOR, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.XOR, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.READER, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.SEQUENCER, SequencerRenderer::new);
        LogicRenderers.register(LogicTypes.PULSE_THROTTLER, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.SELECTOR, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.RANDOMIZER, SimpleLogicRenderer::new);
        LogicRenderers.register(LogicTypes.T_FLIP_FLOP, OnOffLogicRenderer::new);
        LogicRenderers.register(LogicTypes.RS_NOR_LATCH, OnOffLogicRenderer::new);
    }
}

