/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.logic;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.Tags;
import net.swedz.little_big_redstone.LBRTags;

public record DyeComponentResult(Result result, Action action, Optional<DyeColor> color, boolean consume) {
    public boolean success() {
        return this.result == Result.SUCCESS;
    }

    public void playSound(Entity entity) {
        if (this.action != null) {
            entity.playSound(this.action.sound());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean is(ItemStack stack) {
        Item item;
        if (stack.is(Tags.Items.DYES) && (item = stack.getItem()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return true;
        } else if (!stack.is(LBRTags.Items.DYE_WASHER)) return false;
        return true;
    }

    public static DyeComponentResult test(ItemStack carried, Optional<DyeColor> currentColor) {
        boolean consume;
        Action action;
        Result result;
        Item item;
        Optional<DyeColor> color = Optional.empty();
        if (carried.is(Tags.Items.DYES) && (item = carried.getItem()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            result = Result.SUCCESS;
            color = Optional.of(dyeItem.getDyeColor());
            action = Action.DYE;
            consume = true;
        } else if (carried.is(LBRTags.Items.DYE_WASHER)) {
            result = Result.SUCCESS;
            action = Action.WASH;
            consume = carried.is(LBRTags.Items.DYE_WASHER_CONSUMED);
        } else {
            return new DyeComponentResult(Result.WRONG_ITEM, null, Optional.empty(), false);
        }
        if (currentColor.equals(color)) {
            return new DyeComponentResult(Result.NO_CHANGE, null, Optional.empty(), false);
        }
        return new DyeComponentResult(result, action, color, consume);
    }

    public static enum Result {
        SUCCESS,
        WRONG_ITEM,
        NO_CHANGE;

    }

    public static enum Action {
        DYE(SoundEvents.DYE_USE),
        WASH(SoundEvents.BUCKET_EMPTY);

        private final SoundEvent sound;

        private Action(SoundEvent sound) {
            this.sound = sound;
        }

        public SoundEvent sound() {
            return this.sound;
        }
    }
}

