/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBRMenus;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;

public final class LogicConfigMenu
extends AbstractContainerMenu {
    private final BlockPos blockPos;
    private final Supplier<Boolean> validChecker;
    private final DyeColor color;
    private final LogicEntry logicEntry;
    private final MicrochipViewPosition returnViewPosition;

    public LogicConfigMenu(int containerId, Inventory playerInventory, BlockPos blockPos, Supplier<Boolean> validChecker, DyeColor color, LogicEntry logicEntry, MicrochipViewPosition returnViewPosition) {
        super(LBRMenus.LOGIC_CONFIG.get(), containerId);
        this.blockPos = blockPos;
        this.validChecker = validChecker;
        this.color = color;
        this.logicEntry = logicEntry;
        this.returnViewPosition = returnViewPosition;
    }

    public LogicConfigMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        super(LBRMenus.LOGIC_CONFIG.get(), containerId);
        this.blockPos = buf.readBlockPos();
        this.validChecker = null;
        this.color = (DyeColor)DyeColor.STREAM_CODEC.decode((Object)buf);
        this.logicEntry = (LogicEntry)LogicEntry.STREAM_CODEC.decode((Object)buf);
        this.returnViewPosition = (MicrochipViewPosition)MicrochipViewPosition.STREAM_CODEC.decode((Object)buf);
    }

    public BlockPos blockPos() {
        return this.blockPos;
    }

    public DyeColor color() {
        return this.color;
    }

    public LogicEntry logicEntry() {
        return this.logicEntry;
    }

    public MicrochipViewPosition returnViewPosition() {
        return this.returnViewPosition;
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return (this.validChecker == null || this.validChecker.get() != false) && player.blockPosition().closerThan((Vec3i)this.blockPos, 10.0);
    }
}

