/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.entity.stickynote;

import com.mojang.serialization.DynamicOps;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBREntities;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.client.model.stickynote.StickyNoteModelData;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.network.packet.StickyNotePacket;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.DirectionHelper;

public final class StickyNoteEntity
extends HangingEntity {
    private static final EntityDataAccessor<Integer> DATA_FACING = SynchedEntityData.defineId(StickyNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_QUADRANT = SynchedEntityData.defineId(StickyNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.defineId(StickyNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_TEXT_COLOR = SynchedEntityData.defineId(StickyNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_HAS_TEXT = SynchedEntityData.defineId(StickyNoteEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Direction facing = Direction.SOUTH;
    private Quadrant quadrant = Quadrant.TOP_LEFT;
    private DyeColor color = DyeColor.WHITE;
    private DyeColor textColor = StickyNoteItem.getDefaultTextColor(DyeColor.WHITE);
    private StickyNote note = StickyNote.EMPTY;
    private Component itemName;

    public static double boundsDepth() {
        return 0.0625;
    }

    public static double boundsWidth() {
        return 0.4375;
    }

    public static double boundsPositionOffset() {
        return 0.5 - StickyNoteEntity.boundsDepth() / 2.0;
    }

    public StickyNoteEntity(EntityType<? extends StickyNoteEntity> type, Level level) {
        super(type, level);
    }

    public StickyNoteEntity(Level level, BlockPos pos, Direction direction, Direction facing, Quadrant quadrant, DyeColor color, DyeColor textColor) {
        super(LBREntities.STICKY_NOTE.get(), level, pos);
        this.setDirection(direction);
        this.setFacing(facing);
        this.setQuadrant(quadrant);
        this.setColor(color);
        this.setTextColor(textColor);
        this.recalculateBoundingBox();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(StickyNoteModelData.KEY, (Object)new StickyNoteModelData(this.color, this.getTextColor(), (Boolean)this.entityData.get(DATA_HAS_TEXT))).build();
    }

    protected AABB calculateBoundingBox(BlockPos pos, Direction direction) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos).relative(direction, -StickyNoteEntity.boundsPositionOffset());
        center = this.quadrant.relative(this, center, StickyNoteEntity.boundsWidth() / 2.0 + 0.03125);
        Direction.Axis axis = direction.getAxis();
        double dx = axis == Direction.Axis.X ? StickyNoteEntity.boundsDepth() : StickyNoteEntity.boundsWidth();
        double dy = axis == Direction.Axis.Y ? StickyNoteEntity.boundsDepth() : StickyNoteEntity.boundsWidth();
        double dz = axis == Direction.Axis.Z ? StickyNoteEntity.boundsDepth() : StickyNoteEntity.boundsWidth();
        return AABB.ofSize((Vec3)center, (double)dx, (double)dy, (double)dz);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.WOOL_PLACE, 1.0f, 1.0f);
    }

    public ItemStack asItem(boolean includeData) {
        ItemStack stack = ((StickyNoteItem)LBRItems.stickyNote(this.color).get()).getDefaultInstance();
        if (includeData) {
            stack.set(LBRComponents.STICKY_NOTE, (Object)this.note);
            stack.set(LBRComponents.STICKY_NOTE_TEXT_COLOR, (Object)this.textColor);
            if (this.itemName != null) {
                stack.set(DataComponents.CUSTOM_NAME, (Object)this.itemName);
            }
        }
        return stack;
    }

    public void dropItem(Entity breaker) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.WOOL_BREAK, 1.0f, 1.0f);
            if (breaker instanceof Player && (player = (Player)breaker).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(this.asItem(true));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FACING, (Object)Direction.SOUTH.get2DDataValue());
        builder.define(DATA_QUADRANT, (Object)0);
        builder.define(DATA_COLOR, (Object)DyeColor.WHITE.getId());
        builder.define(DATA_TEXT_COLOR, (Object)StickyNoteItem.getDefaultTextColor(DyeColor.WHITE).getId());
        builder.define(DATA_HAS_TEXT, (Object)false);
    }

    protected void setDirection(Direction direction) {
        Assert.notNull((Object)direction);
        this.direction = direction;
        if (direction.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot((float)direction.get2DDataValue() * 90.0f);
        } else {
            this.setXRot(-90.0f * (float)direction.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    public float getVisualRotationYInDegrees() {
        int offset = this.direction.getAxis().isVertical() ? 90 * this.direction.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees((int)(180 + this.direction.get2DDataValue() * 90 + offset));
    }

    public Direction directionRelativeUp() {
        return DirectionHelper.relativeUp((Direction)this.direction, (Direction)this.facing);
    }

    public Direction directionRelativeDown() {
        return DirectionHelper.relativeDown((Direction)this.direction, (Direction)this.facing);
    }

    public Direction directionRelativeLeft() {
        return DirectionHelper.relativeLeft((Direction)this.direction, (Direction)this.facing);
    }

    public Direction directionRelativeRight() {
        return DirectionHelper.relativeRight((Direction)this.direction, (Direction)this.facing);
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        Assert.notNull((Object)facing);
        Assert.that((boolean)facing.getAxis().isHorizontal());
        this.facing = facing;
        this.entityData.set(DATA_FACING, (Object)facing.get2DDataValue());
    }

    public Quadrant getQuadrant() {
        return this.quadrant;
    }

    public void setQuadrant(Quadrant quadrant) {
        Assert.notNull((Object)((Object)quadrant));
        this.quadrant = quadrant;
        this.entityData.set(DATA_QUADRANT, (Object)quadrant.id());
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        Assert.notNull((Object)color);
        this.color = color;
        this.entityData.set(DATA_COLOR, (Object)color.getId());
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(DyeColor textColor) {
        this.textColor = textColor == null ? StickyNoteItem.getDefaultTextColor(this.color) : textColor;
        this.entityData.set(DATA_TEXT_COLOR, (Object)textColor.getId());
    }

    public StickyNote getNote() {
        return this.note;
    }

    public void setNote(StickyNote note) {
        Assert.notNull((Object)note);
        this.note = note;
        this.entityData.set(DATA_HAS_TEXT, (Object)(!note.isEmpty() ? 1 : 0));
    }

    public void setItemName(Component itemName) {
        this.itemName = itemName;
    }

    public boolean survives() {
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        boolean notInsideBlock = BlockPos.betweenClosedStream((AABB)this.calculateSupportBox()).filter(pos -> !Block.canSupportCenter((LevelReader)this.level(), (BlockPos)pos, (Direction)this.direction)).allMatch(pos -> {
            BlockState blockstate = this.level().getBlockState(pos);
            return blockstate.isSolid() || DiodeBlock.isDiode((BlockState)blockstate);
        });
        boolean notInsideHangingEntity = this.level().getEntities((Entity)this, this.getBoundingBox(), other -> {
            if (other instanceof HangingEntity) {
                if (other instanceof StickyNoteEntity) {
                    StickyNoteEntity otherNote = (StickyNoteEntity)((Object)other);
                    return this.direction == otherNote.getDirection() && this.facing == otherNote.getFacing() && this.quadrant == otherNote.getQuadrant();
                }
                return true;
            }
            return false;
        }).isEmpty();
        return notInsideBlock && notInsideHangingEntity;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide()) {
            DyeColor defaultColor;
            DyeItem dyeItem;
            ItemStack stack = player.getItemInHand(hand);
            Item item = stack.getItem();
            if (item instanceof DyeItem && (dyeItem = (DyeItem)item).getDyeColor() != this.getTextColor()) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                this.playSound(SoundEvents.DYE_USE);
                this.setTextColor(dyeItem.getDyeColor());
                stack.consume(1, (LivingEntity)player);
                return InteractionResult.CONSUME;
            }
            if (stack.is(LBRTags.Items.DYE_WASHER) && this.textColor != (defaultColor = StickyNoteItem.getDefaultTextColor(this.color))) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                this.playSound(SoundEvents.BUCKET_EMPTY);
                this.setTextColor(defaultColor);
                if (stack.is(LBRTags.Items.DYE_WASHER_CONSUMED)) {
                    stack.consume(1, (LivingEntity)player);
                }
                return InteractionResult.CONSUME;
            }
            StickyNotePacket.Action action = player.isShiftKeyDown() ? StickyNotePacket.Action.OPEN_EDIT : StickyNotePacket.Action.OPEN_VIEW;
            new StickyNotePacket(StickyNotePacket.ReferenceType.ENTITY, this.getId(), action, this.note.text()).sendToClient((ServerPlayer)player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        int data = this.direction.get3DDataValue() & 7 | (this.facing.get2DDataValue() & 7) << 3 | (this.quadrant.id() & 3) << 6 | (this.color.getId() & 0xF) << 8 | (this.getTextColor().getId() & 0xF) << 12 | (!this.note.isEmpty() ? 1 : 0) << 16;
        return new ClientboundAddEntityPacket((Entity)this, data, this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        this.setDirection(Direction.from3DDataValue((int)(data & 7)));
        this.setFacing(Direction.from2DDataValue((int)(data >> 3 & 7)));
        this.setQuadrant(Quadrant.byId(data >> 6 & 3));
        this.setColor(DyeColor.byId((int)(data >> 8 & 0xF)));
        this.setTextColor(DyeColor.byId((int)(data >> 12 & 0xF)));
        this.entityData.set(DATA_HAS_TEXT, (Object)((data >> 16 & 1) != 0 ? 1 : 0));
        this.recalculateBoundingBox();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(DATA_TEXT_COLOR)) {
            this.textColor = DyeColor.byId((int)((Integer)this.getEntityData().get(DATA_TEXT_COLOR)));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("AttachedFace", (byte)this.direction.get3DDataValue());
        compound.putByte("Facing", (byte)this.facing.get2DDataValue());
        compound.putByte("Quadrant", (byte)this.quadrant.id());
        compound.putByte("Color", (byte)this.color.getId());
        compound.putByte("TextColor", (byte)this.textColor.getId());
        if (this.itemName != null) {
            compound.putString("ItemName", Component.Serializer.toJson((Component)this.itemName, (HolderLookup.Provider)this.registryAccess()));
        }
        compound.put("StickyNote", (Tag)StickyNote.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.note).getOrThrow());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setDirection(Direction.from3DDataValue((int)compound.getByte("AttachedFace")));
        this.setFacing(Direction.from2DDataValue((int)compound.getByte("Facing")));
        this.setQuadrant(Quadrant.byId(compound.getByte("Quadrant")));
        this.setColor(DyeColor.byId((int)compound.getByte("Color")));
        this.setTextColor(DyeColor.byId((int)compound.getByte("TextColor")));
        if (compound.contains("ItemName")) {
            this.setItemName((Component)Component.Serializer.fromJson((String)compound.getString("ItemName"), (HolderLookup.Provider)this.registryAccess()));
        }
        StickyNote.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("StickyNote")).ifSuccess(this::setNote).ifError(error -> LBR.LOGGER.error("Failed to load sticky note data at {}: {}", (Object)this.pos.toShortString(), (Object)error.message()));
        this.recalculateBoundingBox();
    }

    public static enum Quadrant {
        TOP_LEFT(0){

            @Override
            public Vec3 relative(Direction up, Direction down, Direction left, Direction right, Vec3 pos, double distance) {
                pos = pos.add((double)up.getStepX() * distance, (double)up.getStepY() * distance, (double)up.getStepZ() * distance);
                pos = pos.add((double)left.getStepX() * distance, (double)left.getStepY() * distance, (double)left.getStepZ() * distance);
                return pos;
            }
        }
        ,
        TOP_RIGHT(1){

            @Override
            public Vec3 relative(Direction up, Direction down, Direction left, Direction right, Vec3 pos, double distance) {
                pos = pos.add((double)up.getStepX() * distance, (double)up.getStepY() * distance, (double)up.getStepZ() * distance);
                pos = pos.add((double)right.getStepX() * distance, (double)right.getStepY() * distance, (double)right.getStepZ() * distance);
                return pos;
            }
        }
        ,
        BOTTOM_LEFT(2){

            @Override
            public Vec3 relative(Direction up, Direction down, Direction left, Direction right, Vec3 pos, double distance) {
                pos = pos.add((double)down.getStepX() * distance, (double)down.getStepY() * distance, (double)down.getStepZ() * distance);
                pos = pos.add((double)left.getStepX() * distance, (double)left.getStepY() * distance, (double)left.getStepZ() * distance);
                return pos;
            }
        }
        ,
        BOTTOM_RIGHT(3){

            @Override
            public Vec3 relative(Direction up, Direction down, Direction left, Direction right, Vec3 pos, double distance) {
                pos = pos.add((double)down.getStepX() * distance, (double)down.getStepY() * distance, (double)down.getStepZ() * distance);
                pos = pos.add((double)right.getStepX() * distance, (double)right.getStepY() * distance, (double)right.getStepZ() * distance);
                return pos;
            }
        };

        private static final IntFunction<Quadrant> BY_ID;
        private final int id;

        private Quadrant(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public abstract Vec3 relative(Direction var1, Direction var2, Direction var3, Direction var4, Vec3 var5, double var6);

        public Vec3 relative(StickyNoteEntity entity, Vec3 pos, double distance) {
            return this.relative(entity.directionRelativeUp(), entity.directionRelativeDown(), entity.directionRelativeLeft(), entity.directionRelativeRight(), pos, distance);
        }

        public static Quadrant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.continuous(Quadrant::id, (Object[])Quadrant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        }
    }
}

