/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.datagen.server.provider.recipes;

import com.mojang.datafixers.util.Either;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.tesseract.neoforge.compat.vanilla.recipe.ShapedRecipeBuilder;

public final class LogicRecipesDatagenProvider
extends RecipeProvider {
    private static final Map<Character, Either<ItemLike, TagKey<Item>>> ITEMS = Map.of(Character.valueOf('R'), Either.right((Object)Tags.Items.DUSTS_REDSTONE), Character.valueOf('r'), Either.left(LBRItems.REDSTONE_BIT), Character.valueOf('T'), Either.left((Object)Items.REDSTONE_TORCH), Character.valueOf('E'), Either.left((Object)Items.REPEATER), Character.valueOf('Q'), Either.right((Object)Tags.Items.GEMS_QUARTZ), Character.valueOf('G'), Either.right((Object)Tags.Items.INGOTS_GOLD));

    public LogicRecipesDatagenProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider());
    }

    private static void logicComponent(RecipeOutput output, LogicType<?> type, Consumer<ShapedRecipeBuilder> action) {
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder().output((ItemLike)type.item(), 1);
        action.accept(builder);
        String fullPattern = String.join((CharSequence)"", builder.pattern());
        for (Map.Entry<Character, Either<ItemLike, TagKey<Item>>> entry : ITEMS.entrySet()) {
            Character key = entry.getKey();
            if (!fullPattern.contains(key.toString())) continue;
            entry.getValue().map(item -> builder.define(key.charValue(), new ItemLike[]{item}), tag -> builder.define(key.charValue(), tag));
        }
        builder.offerTo(output, LBR.id("logic/%s".formatted(type.id())));
    }

    protected void buildRecipes(RecipeOutput output, HolderLookup.Provider registries) {
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.IO, b -> b.pattern("R  ").pattern(" r ").pattern("  R"));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.NOT, b -> b.pattern("RrT"));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.AND, b -> b.pattern("T  ").pattern("RrT").pattern("T  "));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.NAND, b -> b.pattern("T  ").pattern("RrR").pattern("T  "));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.OR, b -> b.pattern("R  ").pattern("RrR").pattern("R  "));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.NOR, b -> b.pattern("R  ").pattern("RrT").pattern("R  "));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.XOR, b -> b.pattern("1  ").pattern("Rr2").pattern("2  ").define('1', new ItemLike[]{LBRItems.valueOf("and_gate")}).define('2', new ItemLike[]{LBRItems.valueOf("nor_gate")}));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.READER, b -> b.pattern("R  ").pattern("QrR").pattern("R  "));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.SEQUENCER, b -> b.pattern("GGG").pattern("ErR").pattern("GGG"));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.PULSE_THROTTLER, b -> b.pattern("RrR").pattern(" P ").define('P', new ItemLike[]{Items.STICKY_PISTON}));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.SELECTOR, b -> b.pattern("EGR").pattern("ErR").pattern("EGR"));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.RANDOMIZER, b -> b.pattern("GGR").pattern("1rR").pattern("GGR").define('1', new ItemLike[]{Items.DROPPER}));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.T_FLIP_FLOP, b -> b.pattern("1  ").pattern("2rR").pattern("1  ").define('1', new ItemLike[]{LBRItems.valueOf("nand_gate")}).define('2', new ItemLike[]{LBRItems.valueOf("rs_nor_latch")}));
        LogicRecipesDatagenProvider.logicComponent(output, LogicTypes.RS_NOR_LATCH, b -> b.pattern("R1 ").pattern(" rR").pattern("R1 ").define('1', new ItemLike[]{LBRItems.valueOf("nor_gate")}));
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

