/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteView;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class StickyNoteViewRenderer {
    public static void renderBackground(TesseractGuiGraphics graphics, StickyNoteView note, float alpha) {
        graphics.pose().pushPose();
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.setTexture(LBR.id("textures/gui/sticky_note/background_%s.png".formatted(note.color().getName())));
        graphics.nineSlice(0, 0, 180, 180, 64, 64, 21);
        graphics.setTexture(LBR.id("textures/gui/sticky_note/pin_%s.png".formatted(note.color().getName())));
        graphics.blit(81, 4, 0.0f, 0.0f, 32, 32, 32, 32);
        graphics.resetColor();
        graphics.pose().popPose();
    }

    public static void renderBackground(TesseractGuiGraphics graphics, StickyNoteView note) {
        StickyNoteViewRenderer.renderBackground(graphics, note, 1.0f);
    }

    public static void renderText(TesseractGuiGraphics graphics, StickyNoteView note, float alpha) {
        Font font = Minecraft.getInstance().font;
        graphics.pose().pushPose();
        graphics.pose().translate(5.0f, 27.0f, 0.0f);
        graphics.setColor(LBRColors.stickyNoteText(note.textColor(), alpha));
        graphics.setStringDropShadow(false);
        int index = 0;
        for (FormattedCharSequence line : font.split((FormattedText)note.text(), 170)) {
            Objects.requireNonNull(font);
            int y = index * 9;
            graphics.drawString(line, 0, y);
            ++index;
        }
        graphics.setStringDropShadow(true);
        graphics.resetColor();
        graphics.pose().popPose();
    }

    public static void renderText(TesseractGuiGraphics graphics, StickyNoteView note) {
        StickyNoteViewRenderer.renderText(graphics, note, 1.0f);
    }
}

