/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.world.level.RandomTickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.BiasedToBottomInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.PillarFeature;

public class LargePumpkinFeature
extends Feature<NoneFeatureConfiguration> {
    public LargePumpkinFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int z;
        int y;
        int x;
        PillarFeature.DistanceTestType testType = PillarFeature.DistanceTestType.EUCLIDEAN;
        RandomSource random = context.random();
        int radius = BiasedToBottomInt.of((int)1, (int)3).sample(random);
        int diameter = radius + radius + 1;
        BlockPos featureOrigin = context.origin();
        BlockPos origin = featureOrigin.offset(0, diameter / 2, 0);
        WorldGenLevel level = context.level();
        if (level.getLevel().structureManager().hasAnyStructureAt(origin)) {
            return false;
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int surfaceRadiusCheck = radius - 1;
        if (surfaceRadiusCheck == 0) {
            if (!level.getBlockState((BlockPos)mutableBlockPos.set(featureOrigin.getX(), origin.getY() - 1, featureOrigin.getZ())).canOcclude()) {
                return false;
            }
        } else {
            for (x = -surfaceRadiusCheck; x <= surfaceRadiusCheck; ++x) {
                for (int z2 = -surfaceRadiusCheck; z2 <= surfaceRadiusCheck; ++z2) {
                    mutableBlockPos.setWithOffset((Vec3i)featureOrigin, x, -1, z2);
                    if (level.getBlockState((BlockPos)mutableBlockPos).canOcclude()) continue;
                    return false;
                }
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    mutableBlockPos.setWithOffset((Vec3i)origin, x, y, z);
                    if (!testType.getDistanceTester().withinDistance(origin, (BlockPos)mutableBlockPos, (double)radius + (double)radius * 0.66) || !level.getBlockState((BlockPos)mutableBlockPos).canOcclude()) continue;
                    return false;
                }
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                for (z = -radius; z <= radius; ++z) {
                    ChunkAccess chunk;
                    mutableBlockPos.setWithOffset((Vec3i)origin, x, y, z);
                    if (!testType.getDistanceTester().withinDistance(origin, (BlockPos)mutableBlockPos, (double)radius + (double)radius * 0.66)) continue;
                    level.setBlock((BlockPos)mutableBlockPos, Blocks.PUMPKIN.defaultBlockState(), 2);
                    if (y != -radius || !((chunk = level.getChunk((BlockPos)mutableBlockPos)) instanceof RandomTickScheduler)) continue;
                    RandomTickScheduler randomTickScheduler = (RandomTickScheduler)chunk;
                    randomTickScheduler.scheduleRandomTick((BlockPos)mutableBlockPos.move(Direction.DOWN));
                }
            }
        }
        int stemLength = radius + 1;
        for (int stemIdx = 0; stemIdx < stemLength; ++stemIdx) {
            mutableBlockPos.set(origin.getX(), origin.getY() + radius + stemIdx, origin.getZ());
            level.setBlock((BlockPos)mutableBlockPos, Blocks.OAK_LOG.defaultBlockState(), 2);
        }
        mutableBlockPos.move(Direction.UP);
        mutableBlockPos.move(Direction.Plane.HORIZONTAL.getRandomDirection(random));
        level.setBlock((BlockPos)mutableBlockPos, Blocks.OAK_LOG.defaultBlockState(), 2);
        BlockPos.MutableBlockPos leavesMutable = new BlockPos.MutableBlockPos();
        for (Direction value : Direction.values()) {
            leavesMutable.setWithOffset((Vec3i)mutableBlockPos, value);
            if (!level.getBlockState((BlockPos)leavesMutable).isAir()) continue;
            level.setBlock((BlockPos)leavesMutable, (BlockState)((BlockState)Blocks.OAK_LEAVES.defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }
}

