/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.potionstudios.biomeswevegone.client.renderer.entity.pumpkinwarden.PumpkinWardenModel;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class PumpkinWardenRenderer<T extends PumpkinWarden>
extends GeoEntityRenderer<T> {
    public PumpkinWardenRenderer(EntityRendererProvider.Context context) {
        super(context, new PumpkinWardenModel());
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(0.5f, 0.5f, 0.5f);
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if (bone.getName().equals("RightArm")) {
            poseStack.pushPose();
            poseStack.mulPose(Axis.XP.rotationDegrees(15.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(3.5f));
            poseStack.translate(0.05, 0.2, -1.0);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(animatable.getMainHandItem(), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, packedOverlay, poseStack, bufferSource, animatable.level(), 1);
            poseStack.popPose();
            buffer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable)));
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    protected float getShadowRadius(@NotNull T entity) {
        return ((PumpkinWarden)((Object)entity)).isHiding() ? 0.0f : 0.6f;
    }
}

