/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.rei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiCraftingContainerTransferHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiSettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiStorageGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageScreen;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageSettingsScreen;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.FlatBarrelRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.ShulkerBoxFromChestRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.TierUpgradeRecipesMaker;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.SubtypeInterpreters;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

@REIPluginClient
public class StorageReiClientPlugin
implements REIClientPlugin {
    private static Consumer<WorkstationRegistration> additionalWorkstations = registration -> {};

    public static void addAdditionalWorkstations(Consumer<WorkstationRegistration> additionalWorkstations) {
        StorageReiClientPlugin.additionalWorkstations = StorageReiClientPlugin.additionalWorkstations.andThen(additionalWorkstations);
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(StorageScreen.class, screen -> {
            ArrayList ret = new ArrayList();
            screen.getUpgradeSlotsRectangle().ifPresent(ret::add);
            ret.addAll(screen.getUpgradeSettingsControl().getTabRectangles());
            screen.getSortButtonsRectangle().ifPresent(ret::add);
            return ret.stream().map(r -> new Rectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight())).toList();
        });
        zones.register(StorageSettingsScreen.class, screen -> screen.getExtendedControlsRectangles().stream().map(r -> new Rectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight())).toList());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new ReiStorageGhostIngredientHandler(StorageScreen.class));
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new ReiSettingsGhostIngredientHandler(StorageSettingsScreen.class));
    }

    public void registerDisplays(DisplayRegistry registry) {
        Map<BlockItem, PropertyBasedSubtypeInterpreter> subtypeInterpreters = SubtypeInterpreters.getSubtypeInterpreters();
        DyeRecipesMaker.getRecipes(stack -> SubtypeInterpreters.getSubtypeInterpreter(subtypeInterpreters, stack)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        TierUpgradeRecipesMaker.getShapedCraftingRecipes(stack -> SubtypeInterpreters.getSubtypeInterpreter(subtypeInterpreters, stack)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        TierUpgradeRecipesMaker.getShapelessCraftingRecipes(stack -> SubtypeInterpreters.getSubtypeInterpreter(subtypeInterpreters, stack)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        ShulkerBoxFromChestRecipesMaker.getShapedRecipes(stack -> SubtypeInterpreters.getSubtypeInterpreter(subtypeInterpreters, stack)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        FlatBarrelRecipesMaker.getShapelessRecipes().forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.CRAFTING_UPGRADE.get()))});
        registry.addWorkstations(BuiltinPlugin.STONE_CUTTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.STONECUTTER_UPGRADE.get()))});
        additionalWorkstations.accept(new WorkstationRegistration(registry));
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(ReiCraftingContainerTransferHandler.crafting(StorageContainerMenu.class));
    }

    public static class WorkstationRegistration {
        private final CategoryRegistry registry;

        private WorkstationRegistration(CategoryRegistry registry) {
            this.registry = registry;
        }

        public void addWorkstations(CategoryIdentifier<? extends Display> id, Item ... workstations) {
            this.registry.addWorkstations(id, (EntryStack[])Arrays.stream(workstations).map(EntryStacks::of).toArray(EntryStack[]::new));
        }
    }
}

