/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageInputBlockEntity
extends StorageIOBlockEntity {
    @Nullable
    private IItemHandler itemHandler;

    public StorageInputBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @Override
    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        IItemHandler iItemHandler;
        if (this.getControllerPos().isEmpty()) {
            return null;
        }
        if (this.itemHandler == null && (iItemHandler = (this.itemHandler = super.getExternalItemHandler(null))) instanceof IItemHandlerSimpleInserter) {
            IItemHandlerSimpleInserter simpleInserter = (IItemHandlerSimpleInserter)iItemHandler;
            this.itemHandler = new SingleSlotInputItemHandlerWrapper(simpleInserter);
        }
        return this.itemHandler;
    }

    @Override
    protected void invalidateItemHandlerCache() {
        super.invalidateItemHandlerCache();
        this.itemHandler = null;
    }

    private static class SingleSlotInputItemHandlerWrapper
    implements IItemHandler {
        private final IItemHandlerSimpleInserter itemHandler;

        public SingleSlotInputItemHandlerWrapper(IItemHandlerSimpleInserter itemHandler) {
            this.itemHandler = itemHandler;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.itemHandler.insertItem(stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 99;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }
}

