/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.util;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import owmii.powah.ChargeableItemsEvent;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.util.Player;

public final class ChargeUtil {
    private ChargeUtil() {
    }

    public static long chargeItemsInPlayerInv(net.minecraft.world.entity.player.Player player, long maxPerSlot, long maxTotal) {
        return ChargeUtil.chargeItemsInPlayerInv(player, maxPerSlot, maxTotal, s -> true);
    }

    public static boolean canDischarge(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        return storage != null && storage.canExtract() && storage.getEnergyStored() > 0;
    }

    public static long chargeItemsInPlayerInv(net.minecraft.world.entity.player.Player player, long maxPerSlot, long maxTotal, Predicate<ItemStack> allowStack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Player.invStacks(player).stream().toList());
        ChargeableItemsEvent event = new ChargeableItemsEvent(player);
        NeoForge.EVENT_BUS.post((Event)event);
        stacks.addAll(event.getItems());
        stacks.removeIf(allowStack.negate());
        return ChargeUtil.transferSlotList(IEnergyStorage::receiveEnergy, stacks, maxPerSlot, maxTotal);
    }

    public static long chargeItemsInContainer(Container container, long maxPerSlot, long maxTotal) {
        long ret = ChargeUtil.transferSlotList(IEnergyStorage::receiveEnergy, IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0)).toList(), maxPerSlot, maxTotal);
        container.setChanged();
        return ret;
    }

    public static long chargeItemsInInventory(Inventory inv, int slotFrom, int slotTo, long maxPerSlot, long maxTotal) {
        return ChargeUtil.transferSlotList(IEnergyStorage::receiveEnergy, IntStream.range(slotFrom, slotTo).mapToObj(inv::getStackInSlot).toList(), maxPerSlot, maxTotal);
    }

    public static long dischargeItemsInInventory(Inventory inv, long maxPerSlot, long maxTotal) {
        return ChargeUtil.transferSlotList(IEnergyStorage::extractEnergy, IntStream.range(0, inv.getSlots()).mapToObj(inv::getStackInSlot).toList(), maxPerSlot, maxTotal);
    }

    private static long transferSlotList(EnergyTransferOperation op, Iterable<ItemStack> stacks, long maxPerStack, long maxTotal) {
        long charged = 0L;
        for (ItemStack stack : stacks) {
            IEnergyStorage cap;
            if (stack.isEmpty() || (cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
            charged += (long)op.perform(cap, Ints.saturatedCast((long)Math.min(maxPerStack, maxTotal - charged)), false);
        }
        return charged;
    }

    static interface EnergyTransferOperation {
        public int perform(IEnergyStorage var1, int var2, boolean var3);
    }
}

