/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import owmii.powah.entity.ChargedSnowballEntity;
import owmii.powah.lib.item.ItemBase;

public class ChargedSnowballItem
extends ItemBase {
    public ChargedSnowballItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (!playerIn.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (playerIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide) {
            ChargedSnowballEntity entity = new ChargedSnowballEntity(worldIn, (LivingEntity)playerIn);
            entity.setItem(itemstack);
            entity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            worldIn.addFreshEntity((Entity)entity);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }
}

