/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class CubeModel
extends Model {
    private static final String CUBE = "cube";
    private final ModelPart cube;

    public CubeModel(Function<ResourceLocation, RenderType> renderLayer, ModelPart root) {
        super(renderLayer);
        this.cube = root.getChild(CUBE);
    }

    public static LayerDefinition createDefinition(int pixels) {
        float offset = -((float)pixels / 2.0f);
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        root.addOrReplaceChild(CUBE, CubeListBuilder.create().mirror().addBox(offset, offset, offset, (float)pixels, (float)pixels, (float)pixels), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)(pixels * 4), (int)(pixels * 2));
    }

    public void renderToBuffer(PoseStack matrix, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.cube.render(matrix, buffer, packedLight, packedOverlay);
    }
}

