/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.api.wrench.IWrenchable;
import owmii.powah.api.wrench.WrenchMode;
import owmii.powah.block.energizing.EnergizingOrbTile;
import owmii.powah.block.energizing.EnergizingRodTile;
import owmii.powah.components.PowahComponents;
import owmii.powah.item.WrenchItem;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.client.handler.IHud;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.util.Util;
import owmii.powah.util.math.V3d;

public class EnergizingOrbBlock
extends AbstractBlock<IVariant.Single, EnergizingOrbBlock>
implements SimpleWaterloggedBlock,
IWrenchable,
IHud {
    public EnergizingOrbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.setStateProps(state -> (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN));
        this.shapes.put(Direction.UP, Shapes.join((VoxelShape)EnergizingOrbBlock.box(3.5, 11.0, 3.5, 12.5, 1.77, 12.5), (VoxelShape)EnergizingOrbBlock.box(2.5, 15.0, 2.5, 13.5, 16.0, 13.5), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.DOWN, Shapes.join((VoxelShape)EnergizingOrbBlock.box(3.5, 14.23, 3.5, 12.5, 5.0, 12.5), (VoxelShape)EnergizingOrbBlock.box(2.5, 0.0, 2.5, 13.5, 1.0, 13.5), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.NORTH, Shapes.join((VoxelShape)EnergizingOrbBlock.box(3.5, 3.5, 14.23, 12.5, 12.5, 5.0), (VoxelShape)EnergizingOrbBlock.box(2.5, 2.5, 0.0, 13.5, 13.5, 1.0), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.SOUTH, Shapes.join((VoxelShape)EnergizingOrbBlock.box(3.5, 3.5, 11.0, 12.5, 12.5, 1.77), (VoxelShape)EnergizingOrbBlock.box(2.5, 2.5, 15.0, 13.5, 13.5, 16.0), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.WEST, Shapes.join((VoxelShape)EnergizingOrbBlock.box(14.23, 3.5, 3.5, 5.0, 12.5, 12.5), (VoxelShape)EnergizingOrbBlock.box(0.0, 2.5, 2.5, 1.0, 13.5, 13.5), (BooleanOp)BooleanOp.OR));
        this.shapes.put(Direction.EAST, Shapes.join((VoxelShape)EnergizingOrbBlock.box(11.0, 3.5, 3.5, 1.77, 12.5, 12.5), (VoxelShape)EnergizingOrbBlock.box(15.0, 2.5, 2.5, 16.0, 13.5, 13.5), (BooleanOp)BooleanOp.OR));
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnergizingOrbTile(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileentity = level.getBlockEntity(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            Inventory inv = orb.getInventory();
            ItemStack output = inv.getStackInSlot(0);
            if (held.isEmpty() || !output.isEmpty()) {
                if (!level.isClientSide) {
                    player.getInventory().placeItemBackInInventory(inv.removeNext());
                }
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack copy = held.copy();
            copy.setCount(1);
            if (!inv.addNext(copy).isEmpty() && !player.isCreative()) {
                held.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(held, state, level, pos, player, hand, hitResult);
    }

    @Override
    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.search(worldIn, pos);
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof EnergizingOrbTile) {
            EnergizingOrbTile orb = (EnergizingOrbTile)tileentity;
            return orb.getInventory().getNonEmptyStacks().size();
        }
        return super.getAnalogOutputSignal(state, world, pos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        int range = Powah.config().general.energizing_range;
        List<BlockPos> list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).map(BlockPos::immutable).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.forEach(pos1 -> {
            BlockEntity tileEntity1 = worldIn.getBlockEntity(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && pos.equals((Object)((EnergizingRodTile)tileEntity1).getOrbPos())) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(BlockPos.ZERO);
            }
        });
        list.forEach(pos1 -> {
            BlockState state1 = worldIn.getBlockState(pos1);
            if (state1.getBlock() instanceof EnergizingOrbBlock) {
                ((EnergizingOrbBlock)state1.getBlock()).search(worldIn, (BlockPos)pos1);
            }
        });
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void search(Level worldIn, BlockPos pos) {
        int range = Powah.config().general.energizing_range;
        List list = BlockPos.betweenClosedStream((BlockPos)pos.offset(-range, -range, -range), (BlockPos)pos.offset(range, range, range)).map(BlockPos::immutable).filter(pos1 -> !pos.equals(pos1)).collect(Collectors.toList());
        list.stream().filter(p -> worldIn.isLoaded(pos)).forEach(pos1 -> {
            BlockEntity tileEntity1 = worldIn.getBlockEntity(pos1);
            if (tileEntity1 instanceof EnergizingRodTile && !((EnergizingRodTile)tileEntity1).hasOrb()) {
                ((EnergizingRodTile)tileEntity1).setOrbPos(pos);
            }
        });
    }

    @Override
    public boolean onWrench(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, Direction side, WrenchMode mode, Vec3 hit) {
        BlockEntity tileEntity;
        ItemStack stack;
        if (mode.link() && (stack = player.getItemInHand(hand)).getItem() instanceof WrenchItem && (tileEntity = world.getBlockEntity(pos)) instanceof EnergizingOrbTile) {
            BlockPos rodPos = (BlockPos)stack.get(PowahComponents.LINK_ROD_POS);
            if (rodPos != null) {
                BlockEntity blockEntity = world.getBlockEntity(rodPos);
                if (blockEntity instanceof EnergizingRodTile) {
                    EnergizingRodTile rod = (EnergizingRodTile)blockEntity;
                    V3d v3d = V3d.from(rodPos);
                    if ((int)v3d.distance(pos) <= Powah.config().general.energizing_range) {
                        rod.setOrbPos(pos);
                        player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.done").withStyle(ChatFormatting.GOLD), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.fail").withStyle(ChatFormatting.RED), true);
                    }
                }
                stack.remove(PowahComponents.LINK_ROD_POS);
            } else {
                stack.set(PowahComponents.LINK_ORB_POS, (Object)pos);
                player.displayClientMessage((Component)Component.translatable((String)"chat.powah.wrench.link.start").withStyle(ChatFormatting.YELLOW), true);
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderHud(GuiGraphics gui, BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result, @Nullable BlockEntity te) {
        EnergizingOrbTile orb;
        if (te instanceof EnergizingOrbTile && (orb = (EnergizingOrbTile)te).getBuffer().getCapacity() > 0L) {
            RenderSystem.getModelViewStack().pushMatrix();
            RenderSystem.enableBlend();
            Minecraft mc = Minecraft.getInstance();
            Font font = mc.font;
            int x = mc.getWindow().getGuiScaledWidth() / 2;
            int y = mc.getWindow().getGuiScaledHeight();
            String s = String.valueOf(ChatFormatting.GREEN) + orb.getBuffer().getPercent() + "%";
            String s1 = String.valueOf(ChatFormatting.GRAY) + I18n.get((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(orb.getBuffer().getEnergyStored()), Util.numFormat(orb.getBuffer().getCapacity())});
            gui.drawString(font, s, Math.round((float)x - (float)font.width(s) / 2.0f), y - 90, 0xFFFFFF);
            gui.drawString(font, s1, Math.round((float)x - (float)font.width(s1) / 2.0f), y - 75, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.getModelViewStack().popMatrix();
        }
        return true;
    }
}

