/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.leaves.JoshuaLeavesBlock;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class SmallJoshuaTreeFeature
extends Feature<RuTreeConfiguration> {
    public SmallJoshuaTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main + 2; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck == height_main) {
                this.placeTop((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, treeConfiguration.trunkProvider.getState(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public void placeTop(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        this.placeBranches(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
    }

    public boolean placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        if (SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.north()) && !level.isOutsideBuildHeight(pos.north())) {
            level.setBlock(pos.north(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
        }
        if (SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.south()) && !level.isOutsideBuildHeight(pos.south())) {
            level.setBlock(pos.south(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
        }
        if (SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.east()) && !level.isOutsideBuildHeight(pos.east())) {
            level.setBlock(pos.east(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
        }
        if (SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.west()) && !level.isOutsideBuildHeight(pos.west())) {
            level.setBlock(pos.west(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos.above())) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced() && level.getBlockState(pos.above()).canBeReplaced()) {
            level.setBlock(pos, (BlockState)((BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)JoshuaLeavesBlock.NATURAL, (Comparable)Boolean.valueOf(true))).setValue((Property)JoshuaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            level.setBlock(pos.above(), (BlockState)((BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos.above()).setValue((Property)JoshuaLeavesBlock.NATURAL, (Comparable)Boolean.valueOf(true))).setValue((Property)JoshuaLeavesBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return SmallJoshuaTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SmallJoshuaTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, SmallJoshuaTreeFeature::isReplaceableBlock);
    }
}

