/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class IceSpireFeature
extends Feature<RuTreeConfiguration> {
    public IceSpireFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        int height_2n = height_main > 10 ? height_main / 2 + randomSource.nextInt(3) : height_main / 2;
        int height_2s = height_main > 10 ? height_main / 2 + randomSource.nextInt(3) : height_main / 2;
        int height_2e = height_main > 10 ? height_main / 2 + randomSource.nextInt(3) : height_main / 2;
        int height_2w = height_main > 10 ? height_main / 2 + randomSource.nextInt(3) : height_main / 2;
        int height_ne = randomSource.nextInt(5);
        int height_nw = randomSource.nextInt(5);
        int height_se = randomSource.nextInt(5);
        int height_sw = randomSource.nextInt(5);
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        if (randomSource.nextInt(2) == 0) {
            this.generateSmallSpire((LevelAccessor)level, pos, randomSource, treeConfiguration);
            return true;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck <= height_ne) {
                if (placeCheck == height_ne) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.north().east(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.north().east(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_nw) {
                if (placeCheck == height_nw) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.north().west(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.north().west(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_se) {
                if (placeCheck == height_se) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.south().east(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.south().east(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_sw) {
                if (placeCheck == height_sw) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.south().west(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.south().west(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2n) {
                if (placeCheck == height_2n) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.north(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.north(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2s) {
                if (placeCheck == height_2s) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.south(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.south(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2e) {
                if (placeCheck == height_2e) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.east(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.east(), randomSource, treeConfiguration);
            }
            if (placeCheck <= height_2w) {
                if (placeCheck == height_2w) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.west(), randomSource, treeConfiguration);
                }
                this.placeLog((LevelAccessor)level, placePos.west(), randomSource, treeConfiguration);
            }
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, placePos.below(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().north(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().north().east(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().north().west(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().south(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().south().east(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().south().west(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().east(), randomSource, treeConfiguration);
                this.placeRoot((LevelAccessor)level, placePos.below().west(), randomSource, treeConfiguration);
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.north().north(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.north().north(), randomSource, treeConfiguration);
                }
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.south().south(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.south().south(), randomSource, treeConfiguration);
                }
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.east().east(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.east().east(), randomSource, treeConfiguration);
                }
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlob((LevelAccessor)level, placePos.west().west(), randomSource, treeConfiguration);
                    this.placeRoot((LevelAccessor)level, placePos.west().west(), randomSource, treeConfiguration);
                }
            }
            if (placeCheck == height_main) {
                this.placeLeavesBlob((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public void generateSmallSpire(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos placePos = pos.mutable();
        int size = randomSource.nextInt(3) + 5;
        for (int i = 0; i <= size; ++i) {
            if (i == 0) {
                this.placeRoot(level, pos, randomSource, treeConfiguration);
                this.placeRoot(level, pos.north(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.south(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.east(), randomSource, treeConfiguration);
                this.placeRoot(level, pos.west(), randomSource, treeConfiguration);
            }
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (i == size) {
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        this.placeLog(level, pos.north(), randomSource, treeConfiguration);
        this.placeLog(level, pos.north().above(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.north().above(), randomSource, treeConfiguration);
        this.placeLog(level, pos.south(), randomSource, treeConfiguration);
        this.placeLog(level, pos.south().above(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.south().above(), randomSource, treeConfiguration);
        this.placeLog(level, pos.east(), randomSource, treeConfiguration);
        this.placeLog(level, pos.east().above(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.east().above(), randomSource, treeConfiguration);
        this.placeLog(level, pos.west(), randomSource, treeConfiguration);
        this.placeLog(level, pos.west().above(), randomSource, treeConfiguration);
        this.placeLeavesBlob(level, pos.west().above(), randomSource, treeConfiguration);
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (IceSpireFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, treeConfiguration.trunkProvider.getState(randomSource, pos), 2);
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; !(i > rd || level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)); ++i) {
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int n = random.nextInt(3);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(2), randomSource, treeConfiguration);
        if (randomSource.nextBoolean()) {
            this.placeLeavesBlock(level, pos.above(3), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, treeConfiguration.foliageProvider.getState(randomSource, pos), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return IceSpireFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, IceSpireFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, IceSpireFeature::isReplaceableBlock);
    }
}

