/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.wood;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;

public class PineLogBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty TRANSITION_BLOCK = RuBlockStateProperties.TRANSITION_BLOCK;
    public static final BooleanProperty IS_STRIPPED = RuBlockStateProperties.IS_STRIPPED;

    public PineLogBlock(BlockBehaviour.Properties p_55926_) {
        super(p_55926_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)TRANSITION_BLOCK, (Comparable)Boolean.valueOf(false))).setValue((Property)IS_STRIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState rotate(BlockState p_55930_, Rotation p_55931_) {
        return PineLogBlock.rotatePillar(p_55930_, p_55931_);
    }

    public static BlockState rotatePillar(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        boolean isTransition = false;
        if (!(((Boolean)state.getValue((Property)IS_STRIPPED)).booleanValue() || state.getValue(AXIS) != Direction.Axis.Y || level.getBlockState(pos.below()) != RuBlocks.STRIPPED_PINE_LOG.get().defaultBlockState() && level.getBlockState(pos.below()) != RuBlocks.PINE_LOG.get().defaultBlockState().setValue((Property)IS_STRIPPED, (Comparable)Boolean.valueOf(true)))) {
            isTransition = true;
        }
        return (BlockState)state.setValue((Property)TRANSITION_BLOCK, (Comparable)Boolean.valueOf(isTransition));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55933_) {
        p_55933_.add(new Property[]{AXIS, TRANSITION_BLOCK, IS_STRIPPED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isTransition = false;
        if (!(((Boolean)this.defaultBlockState().getValue((Property)IS_STRIPPED)).booleanValue() || this.defaultBlockState().getValue(AXIS) != Direction.Axis.Y || context.getLevel().getBlockState(context.getClickedPos().below()) != RuBlocks.STRIPPED_PINE_LOG.get().defaultBlockState() && context.getLevel().getBlockState(context.getClickedPos().below()) != RuBlocks.PINE_LOG.get().defaultBlockState().setValue((Property)IS_STRIPPED, (Comparable)Boolean.valueOf(true)))) {
            isTransition = true;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getClickedFace().getAxis())).setValue((Property)TRANSITION_BLOCK, (Comparable)Boolean.valueOf(isTransition));
    }
}

