/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.dusktrap;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.regions_unexplored.world.level.block.plant.dusktrap.BaseDuskTrapBlock;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;

public class DuskTrapBlock
extends BaseDuskTrapBlock {
    public static final BooleanProperty POWERED = RuBlockStateProperties.CLOSED;
    private final Sensitivity sensitivity;

    public DuskTrapBlock(Sensitivity sensitivity, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.sensitivity = sensitivity;
    }

    @Override
    protected int getSignalForState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    @Override
    protected BlockState setSignalForState(BlockState blockState, int signalStrength) {
        return (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signalStrength > 0));
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender(level, pos);
    }

    @Override
    protected int getSignalStrength(Level level, BlockPos blockPos) {
        Class<Entity> oclass = switch (this.sensitivity.ordinal()) {
            case 0 -> Entity.class;
            case 1 -> LivingEntity.class;
            default -> throw new IncompatibleClassChangeError();
        };
        return DuskTrapBlock.getEntityCount(level, TOUCH_AABB.move(blockPos), oclass) > 0 ? 15 : 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{POWERED}).add(new Property[]{HALF});
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS;

    }
}

