/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.aquatic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;
import net.regions_unexplored.world.level.block.state.properties.TallHyacinthStockShape;
import org.jetbrains.annotations.Nullable;

public class TallHyacinthStockBlock
extends Block
implements LiquidBlockContainer {
    public static final EnumProperty<TallHyacinthStockShape> SHAPE = RuBlockStateProperties.TALL_HYACINTH_STOCK_SHAPE;
    protected static final VoxelShape BOX = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public TallHyacinthStockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.BASE_TIP)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{SHAPE});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.getOffset(getter, pos);
        return BOX.move(vec3.x, vec3.y, vec3.z);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (level.getFluidState(pos).is((Fluid)Fluids.WATER) || level.getFluidState(pos).is((Fluid)Fluids.FLOWING_WATER)) {
            if (level.getFluidState(pos).getAmount() != 8) {
                return false;
            }
            BlockPos blockpos = pos.below();
            return this.mayPlaceOn(level.getBlockState(blockpos), (BlockGetter)level, blockpos);
        }
        return false;
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.isFaceSturdy(getter, pos, Direction.UP) || state.is(RuBlocks.TALL_HYACINTH_STOCK.get());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (!context.getLevel().getBlockState(context.getClickedPos().below()).is(RuBlocks.TALL_HYACINTH_STOCK.get())) {
            return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.BASE_TIP));
        }
        return (BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        TallHyacinthStockShape shape = (TallHyacinthStockShape)((Object)state.getValue(SHAPE));
        if (!level.getBlockState(pos.below()).is(RuBlocks.TALL_HYACINTH_STOCK.get())) {
            shape = !level.getBlockState(pos.above()).is(RuBlocks.TALL_HYACINTH_STOCK.get()) ? TallHyacinthStockShape.BASE_TIP : (level.getBlockState(pos.above()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP)) ? TallHyacinthStockShape.BASE_FRUSTUM : TallHyacinthStockShape.BASE);
        } else if (!level.getBlockState(pos.above()).is(RuBlocks.TALL_HYACINTH_STOCK.get())) {
            shape = TallHyacinthStockShape.TIP;
        } else if (level.getBlockState(pos.above()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.TIP))) {
            shape = TallHyacinthStockShape.FRUSTUM;
        } else if (level.getBlockState(pos.above()) == RuBlocks.TALL_HYACINTH_STOCK.get().defaultBlockState().setValue(SHAPE, (Comparable)((Object)TallHyacinthStockShape.FRUSTUM))) {
            shape = TallHyacinthStockShape.MIDDLE;
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
    }

    public FluidState getFluidState(BlockState p_154537_) {
        return Fluids.WATER.getSource(false);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter p_154505_, BlockPos p_154506_, BlockState p_154507_, Fluid p_154508_) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor p_154520_, BlockPos p_154521_, BlockState p_154522_, FluidState p_154523_) {
        return false;
    }
}

