/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class RsSignals {
    public static boolean hasSignalConnector(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction real_side) {
        return state.isSignalSource();
    }

    public static int fromContainer(@Nullable Container container) {
        if (container == null) {
            return 0;
        }
        double max = container.getMaxStackSize();
        if (max <= 0.0) {
            return 0;
        }
        boolean nonempty = false;
        double fill_level = 0.0;
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.isEmpty() || stack.getMaxStackSize() <= 0) continue;
            fill_level += (double)stack.getCount() / Math.min(max, (double)stack.getMaxStackSize());
            nonempty = true;
        }
        return (int)(Math.floor((fill_level /= (double)container.getContainerSize()) * 14.0) + (double)(nonempty ? 1 : 0));
    }

    public static boolean canEmitWeakPower(BlockState state, Level world, BlockPos pos, Direction redstone_side) {
        return state.isRedstoneConductor((BlockGetter)world, pos);
    }
}

