/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.libmc;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import wile.redstonepen.libmc.Networking;

public class Overlay {
    private static double overlay_y_ = 0.75;
    private static int text_color_ = 0xFFAA00;
    private static int border_color_ = -1439485133;
    private static int background_color1_ = -1439485133;
    private static int background_color2_ = -1438366652;

    @OnlyIn(value=Dist.CLIENT)
    public static void register() {
        Networking.OverlayTextMessage.setHandler(TextOverlayGui::show);
    }

    public static void show(ServerPlayer player, Component message) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, 3000);
    }

    public static void show(ServerPlayer player, Component message, int delay) {
        Networking.OverlayTextMessage.sendToPlayer(player, message, delay);
    }

    public static void show(BlockState state, BlockPos pos) {
        Overlay.show(state, pos, 100);
    }

    public static void show(BlockState state, BlockPos pos, int displayTimeoutMs) {
        Minecraft.getInstance().execute(() -> TextOverlayGui.show(state, pos, displayTimeoutMs));
    }

    public static void on_config(double overlay_y) {
        Overlay.on_config(overlay_y, 0xFFAA00, -1439485133, -1439485133, -1438366652);
    }

    public static void on_config(double overlay_y, int text_color, int border_color, int background_color1, int background_color2) {
        overlay_y_ = overlay_y;
        text_color_ = text_color;
        border_color_ = border_color;
        background_color1_ = background_color1;
        background_color2_ = background_color2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TextOverlayGui
    extends Screen {
        public static final TextOverlayGui INSTANCE = new TextOverlayGui();
        public static final Component EMPTY_TEXT = Component.literal((String)"");
        public static final BlockState EMPTY_STATE = null;
        private static long text_deadline_ = 0L;
        private static Component text_ = EMPTY_TEXT;
        private static long state_deadline_ = 0L;
        @Nullable
        private static BlockState state_ = EMPTY_STATE;
        private static BlockPos pos_ = BlockPos.ZERO;

        public static synchronized Component text() {
            return text_;
        }

        public static synchronized long deadline() {
            return text_deadline_;
        }

        public static synchronized void hide() {
            text_deadline_ = 0L;
            text_ = EMPTY_TEXT;
        }

        public static synchronized void show(Component s, int displayTimeoutMs) {
            text_ = s == null ? EMPTY_TEXT : s.copy();
            text_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(String s, int displayTimeoutMs) {
            text_ = s == null || s.isEmpty() ? EMPTY_TEXT : Component.literal((String)s);
            text_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        public static synchronized void show(BlockState state, BlockPos pos, int displayTimeoutMs) {
            pos_ = new BlockPos((Vec3i)pos);
            state_ = state;
            state_deadline_ = System.currentTimeMillis() + (long)displayTimeoutMs;
        }

        private static synchronized Optional<Tuple<BlockState, BlockPos>> state_pos() {
            return state_deadline_ < System.currentTimeMillis() || state_ == EMPTY_STATE ? Optional.empty() : Optional.of(new Tuple((Object)state_, (Object)pos_));
        }

        TextOverlayGui() {
            super((Component)Component.literal((String)"redstonepenOverlay"));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onRenderGui(GuiGraphics gg) {
            if (TextOverlayGui.deadline() < System.currentTimeMillis()) {
                return;
            }
            if (TextOverlayGui.text() == EMPTY_TEXT) {
                return;
            }
            String txt = TextOverlayGui.text().getString();
            if (txt.isEmpty()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            Window win = mc.getWindow();
            Font fr = mc.font;
            boolean was_unicode = fr.isBidirectional();
            int cx = win.getGuiScaledWidth() / 2;
            int cy = (int)((double)win.getGuiScaledHeight() * overlay_y_);
            int w = fr.width(txt);
            Objects.requireNonNull(fr);
            int h = 9;
            gg.fillGradient(cx - w / 2 - 3, cy - 2, cx + w / 2 + 2, cy + h + 2, -1439485133, -1438366652);
            gg.hLine(cx - w / 2 - 3, cx + w / 2 + 2, cy - 2, -1439485133);
            gg.hLine(cx - w / 2 - 3, cx + w / 2 + 2, cy + h + 2, -1439485133);
            gg.vLine(cx - w / 2 - 3, cy - 2, cy + h + 2, -1439485133);
            gg.vLine(cx + w / 2 + 2, cy - 2, cy + h + 2, -1439485133);
            gg.drawCenteredString(fr, TextOverlayGui.text(), cx, cy + 1, 0xFFAA00);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onRenderWorldOverlay(PoseStack mxs, double partialTick) {
            Optional<Tuple<BlockState, BlockPos>> sp = TextOverlayGui.state_pos();
            if (sp.isEmpty()) {
                return;
            }
            Minecraft mc = Minecraft.getInstance();
            ClientLevel world = mc.level;
            LocalPlayer player = mc.player;
            if (player == null || world == null) {
                return;
            }
            BlockState state = (BlockState)sp.get().getA();
            BlockPos pos = (BlockPos)sp.get().getB();
            int light = world.hasChunkAt(pos) ? LightTexture.pack((int)world.getBrightness(LightLayer.BLOCK, pos), (int)world.getBrightness(LightLayer.SKY, pos)) : LightTexture.pack((int)15, (int)15);
            MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
            double px = Mth.lerp((double)partialTick, (double)player.xo, (double)player.getX());
            double py = Mth.lerp((double)partialTick, (double)player.yo, (double)player.getY());
            double pz = Mth.lerp((double)partialTick, (double)player.zo, (double)player.getZ());
            mxs.pushPose();
            mxs.translate((double)pos.getX() - px, (double)pos.getY() - py - (double)player.getEyeHeight(), (double)pos.getZ() - pz);
            mc.getBlockRenderer().renderSingleBlock(state, mxs, (MultiBufferSource)buffer, light, OverlayTexture.NO_OVERLAY);
            mxs.popPose();
        }
    }
}

