/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.util.RenderUtil;

public class AnimatableTexture
extends SimpleTexture {
    protected AnimationContents animationContents = null;
    protected boolean isAnimated = false;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public void load(ResourceManager manager) throws IOException {
        Resource resource = manager.getResourceOrThrow(this.location);
        AnimationMetadataSection animMeta = resource.metadata().getSection((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER).orElse(null);
        if (animMeta != null) {
            NativeImage nativeImage;
            try (InputStream inputstream = resource.open();){
                nativeImage = NativeImage.read((InputStream)inputstream);
            }
            this.animationContents = new AnimationContents(nativeImage, animMeta);
            if (!this.animationContents.isValid()) {
                nativeImage.close();
                return;
            }
            this.isAnimated = true;
            AnimatableTexture.onRenderThread(() -> {
                TextureUtil.prepareImage((int)this.getId(), (int)0, (int)this.animationContents.frameSize.width(), (int)this.animationContents.frameSize.height());
                nativeImage.upload(0, 0, 0, 0, 0, this.animationContents.frameSize.width(), this.animationContents.frameSize.height(), false, false);
            });
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public static void setAndUpdate(ResourceLocation texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtil.getCurrentTick());
    }

    public static void setAndUpdate(ResourceLocation texturePath, int frameTick) {
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(texturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(frameTick);
        }
        RenderSystem.setShaderTexture((int)0, (int)texture.getId());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null && this.animationContents.animatedTexture != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private static void onRenderThread(RenderCall renderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((RenderCall)renderCall);
        } else {
            renderCall.execute();
        }
    }

    protected class AnimationContents {
        protected final FrameSize frameSize;
        protected final Texture animatedTexture;

        private AnimationContents(NativeImage image, AnimationMetadataSection animMeta) {
            this.frameSize = animMeta.calculateFrameSize(image.getWidth(), image.getHeight());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        private Texture generateAnimatedTexture(NativeImage image, AnimationMetadataSection animMeta) {
            if (!Mth.isMultipleOf((int)image.getWidth(), (int)this.frameSize.width()) || !Mth.isMultipleOf((int)image.getHeight(), (int)this.frameSize.height())) {
                GeckoLibConstants.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.location, (Object)image.getWidth(), (Object)image.getHeight(), (Object)this.frameSize.width(), (Object)this.frameSize.height());
                return null;
            }
            int columns = image.getWidth() / this.frameSize.width();
            int rows = image.getHeight() / this.frameSize.height();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            animMeta.forEachFrame((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.getDefaultFrameTime()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        GeckoLibConstants.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.location, (Object)index, (Object)frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        GeckoLibConstants.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.location, (Object)index, (Object)frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    GeckoLibConstants.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.location, (Object)Arrays.toString(unusedFrames.toArray()));
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.isInterpolatedFrames());
        }

        private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        protected class Texture
        implements AutoCloseable {
            protected final NativeImage baseImage;
            protected final Frame[] frames;
            protected final int framePanelSize;
            protected final boolean interpolating;
            protected final NativeImage interpolatedFrame;
            protected final int totalFrameTime;
            protected int glowMaskTextureId = -1;
            protected NativeImage glowmaskImage = null;
            protected NativeImage glowmaskInterpolatedFrame = null;
            protected int currentFrame;
            protected int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setGlowMaskTexture(AutoGlowingTexture texture, NativeImage baseImage, NativeImage glowMask) {
                this.glowMaskTextureId = texture.getId();
                this.glowmaskImage = glowMask;
                this.glowmaskInterpolatedFrame = this.interpolating ? new NativeImage(AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false) : null;
                this.baseImage.copyFrom(baseImage);
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.prepareImage((int)AnimatableTexture.this.getId(), (int)0, (int)AnimationContents.this.frameSize.width(), (int)AnimationContents.this.frameSize.height());
                        this.baseImage.upload(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.width(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.height(), AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false, false);
                        if (this.glowmaskImage != null) {
                            TextureUtil.prepareImage((int)this.glowMaskTextureId, (int)0, (int)AnimationContents.this.frameSize.width(), (int)AnimationContents.this.frameSize.height());
                            this.glowmaskImage.upload(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.width(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.height(), AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false, false);
                        }
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(() -> {
                        this.generateInterpolatedFrame(AnimatableTexture.this.getId(), this.baseImage, this.interpolatedFrame);
                        if (this.glowmaskImage != null) {
                            this.generateInterpolatedFrame(this.glowMaskTextureId, this.glowmaskImage, this.glowmaskInterpolatedFrame);
                        }
                    });
                }
            }

            private void generateInterpolatedFrame(int textureId, NativeImage image, NativeImage interpolatedFrame) {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < interpolatedFrame.getHeight(); ++y) {
                        for (int x = 0; x < interpolatedFrame.getWidth(); ++x) {
                            int prevFramePixel = this.getPixel(image, frame.index, x, y);
                            int nextFramePixel = this.getPixel(image, nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            interpolatedFrame.setPixelRGBA(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.prepareImage((int)textureId, (int)0, (int)AnimationContents.this.frameSize.width(), (int)AnimationContents.this.frameSize.height());
                    interpolatedFrame.upload(0, 0, 0, 0, 0, AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false, false);
                }
            }

            private int getPixel(NativeImage image, int frameIndex, int x, int y) {
                return image.getPixelRGBA(x + this.getFrameX(frameIndex) * AnimationContents.this.frameSize.width(), y + this.getFrameY(frameIndex) * AnimationContents.this.frameSize.height());
            }

            private int interpolate(double frameProgress, double prevColor, double nextColor) {
                return (int)(frameProgress * prevColor + (1.0 - frameProgress) * nextColor);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
                if (this.glowmaskImage != null) {
                    this.glowmaskImage.close();
                }
                if (this.glowmaskInterpolatedFrame != null) {
                    this.glowmaskInterpolatedFrame.close();
                }
            }
        }

        protected record Frame(int index, int time) {
        }
    }
}

