/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.shiny.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.FrogModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.frog.Frog;

public class FrogShinyLayer
extends RenderLayer<Frog, FrogModel<Frog>> {
    private static final Map<String, RenderType> SHINE = (Map)Util.make((Object)Maps.newHashMap(), map -> {
        map.put("temperate", RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/frog/temperate_frog.png")));
        map.put("warm", RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/frog/warm_frog.png")));
        map.put("cold", RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/frog/cold_frog.png")));
    });

    public FrogShinyLayer(RenderLayerParent<Frog, FrogModel<Frog>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, Frog entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            VertexConsumer vertexconsumer = bufferSource.getBuffer(SHINE.getOrDefault(entity.getVariant().toString(), SHINE.get("temperate")));
            ((FrogModel)this.getParentModel()).renderToBuffer(poseStack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY);
        }
    }
}

