/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.shiny.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import cy.jdkdigital.shiny.client.renderer.entity.layers.PiglinShinyLayer;
import cy.jdkdigital.shiny.init.ModEntities;
import java.util.Map;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class ShinyPiglinRenderer
extends PiglinRenderer {
    private static final Map<EntityType<?>, ResourceLocation> TEXTURES = ImmutableMap.of((Object)((EntityType)ModEntities.PIGLIN.get()), (Object)ResourceLocation.withDefaultNamespace((String)"textures/entity/piglin/piglin.png"), (Object)((EntityType)ModEntities.ZOMBIFIED_PIGLIN.get()), (Object)ResourceLocation.withDefaultNamespace((String)"textures/entity/piglin/zombified_piglin.png"), (Object)((EntityType)ModEntities.PIGLIN_BRUTE.get()), (Object)ResourceLocation.withDefaultNamespace((String)"textures/entity/piglin/piglin_brute.png"));

    public ShinyPiglinRenderer(EntityRendererProvider.Context context, ModelLayerLocation body, ModelLayerLocation innerArmor, ModelLayerLocation outerArmor, boolean isZombie) {
        super(context, body, innerArmor, outerArmor, isZombie);
        this.addLayer(new PiglinShinyLayer((RenderLayerParent<Mob, PiglinModel<Mob>>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(Mob entity) {
        ResourceLocation resourcelocation = TEXTURES.get(entity.getType());
        if (resourcelocation == null) {
            throw new IllegalArgumentException("I don't know what texture to use for " + String.valueOf(entity.getType()));
        }
        return resourcelocation;
    }
}

