/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.logistics.depot.DepotBlock;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.ArcanePolishEntity;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.util.Color;

public class EffectPolish
extends AbstractItemResolveEffect {
    public static EffectPolish INSTANCE = new EffectPolish(ArsTechnica.prefix("glyph_polish"), "Polish");
    private static float DEFAULT_SPEED = 2.0f;

    private EffectPolish(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockHitResult blockHit;
        BlockPos blockPos;
        BlockState state;
        if (rayTraceResult instanceof BlockHitResult && (state = world.getBlockState(blockPos = (blockHit = (BlockHitResult)rayTraceResult).getBlockPos())).getBlock() instanceof DepotBlock) {
            boolean hasFocus = SpellResolverHelpers.hasTransmutationFocus(resolver);
            int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
            int maxAmountToPolish = Math.round(4 * (1 + aoeBuff)) * (hasFocus ? 2 : 1);
            float speed = hasFocus ? DEFAULT_SPEED * 2.5f : DEFAULT_SPEED;
            Color color = new Color(spellContext.getSpell().color().getColor());
            Vec3 spawnPos = Vec3.atCenterOf((Vec3i)blockPos).add(0.0, 0.5, 0.0);
            ArcanePolishEntity arcanePolishEntity = new ArcanePolishEntity(spawnPos, world, maxAmountToPolish, speed, color, Collections.emptyList());
            arcanePolishEntity.bindDepot(blockPos);
            world.addFreshEntity((Entity)arcanePolishEntity);
            return;
        }
        super.onResolve(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemEntity closest;
        ArrayList<ItemEntity> validPolishableEntities = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : entityList) {
            ItemStack itemStack = itemEntity.getItem();
            List recipes = SandPaperPolishingRecipe.getMatchingRecipes((Level)world, (ItemStack)itemStack);
            if (recipes.isEmpty()) continue;
            validPolishableEntities.add(itemEntity);
        }
        boolean hasFocus = SpellResolverHelpers.hasTransmutationFocus(resolver);
        int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
        int maxAmountToPolish = Math.round(4 * (1 + aoeBuff)) * (hasFocus ? 2 : 1);
        float speed = hasFocus ? DEFAULT_SPEED * 2.5f : DEFAULT_SPEED;
        Color color = new Color(spellContext.getSpell().color().getColor());
        if (!validPolishableEntities.isEmpty() && (closest = (ItemEntity)validPolishableEntities.stream().min(Comparator.comparingDouble(e -> e.position().distanceTo(posVec))).orElse(null)) != null) {
            ArcanePolishEntity arcanePolishEntity = new ArcanePolishEntity(closest.position().add(0.0, 0.5, 0.0), world, maxAmountToPolish, speed, color, validPolishableEntities);
            world.addFreshEntity((Entity)arcanePolishEntity);
        }
    }

    public int getDefaultManaCost() {
        return 120;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the amount of items processed");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Refines items into their polished variants";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

