/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import com.zeroregard.ars_technica.entity.Colorable;
import com.zeroregard.ars_technica.helpers.ObliterateHelper;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import com.zeroregard.ars_technica.network.ParticleEffectPacket;
import com.zeroregard.ars_technica.registry.EntityRegistry;
import com.zeroregard.ars_technica.registry.ParticleRegistry;
import com.zeroregard.ars_technica.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.util.Color;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcaneHammerEntity
extends Entity
implements GeoEntity,
Colorable {
    private static float UNSCALED_CHARGE_TIME = 2.0f;
    private static float UNSCALED_TIME_TILL_OBLITERATE = 0.25f;
    private static float UNSCALED_TIME_TILL_DISCARD = 1.0f;
    private static float AMPS_SIZE_MULTIPLIER = 0.33333334f;
    private static float AMPS_SPEED_MULTIPLIER = -0.05f;
    private long createdTime;
    private long chargedTime;
    private Entity target;
    private final Level world;
    private Entity caster;
    private SpellResolver resolver;
    private SpellStats spellStats;
    private float ampScalar = 1.5f;
    private float amps = 0.0f;
    private boolean processItems = false;
    private boolean didObliterate = false;
    private boolean isCharging = true;
    private boolean chargeAnimationPlayed = false;
    private BlockPos boundDepotPos;
    private Color color;
    private float yaw;
    private float size = 1.0f;
    private float alpha = 0.0f;
    private float speed = 1.0f;
    private AnimationController<ArcaneHammerEntity> animationController;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ArcaneHammerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(ArcaneHammerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(ArcaneHammerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ALPHA = SynchedEntityData.defineId(ArcaneHammerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(ArcaneHammerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    private static Vec3 getTargetPosition(Entity target) {
        return target.getPosition(1.0f).add(0.0, 0.5, 0.0);
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.entityData.set(YAW, (Object)Float.valueOf(yaw));
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    protected void setAlpha(float alpha) {
        this.entityData.set(ALPHA, (Object)Float.valueOf(alpha));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    protected void setColor(Color color) {
        this.entityData.set(COLOR, (Object)color.getColor());
    }

    public float getSize() {
        return this.size;
    }

    protected void setSize(float size) {
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
    }

    protected void setSpeed(float speed) {
        float clamped;
        this.speed = clamped = Math.max(0.6f, speed);
        this.entityData.set(SPEED, (Object)Float.valueOf(clamped));
    }

    public ArcaneHammerEntity(@Nullable Entity target, Vec3 position, Level world, Entity caster, Color color, SpellResolver resolver, SpellStats spellStats) {
        super((EntityType)EntityRegistry.ARCANE_HAMMER_ENTITY.get(), world);
        this.world = world;
        this.caster = caster;
        this.processItems = spellStats.isSensitive();
        this.resolver = resolver;
        this.spellStats = spellStats;
        this.amps = (float)spellStats.getAmpMultiplier();
        this.target = target;
        this.setPos(position.x, position.y, position.z);
        this.setColor(color);
        this.setSize(1.0f + this.amps * AMPS_SIZE_MULTIPLIER);
        this.setSpeed(1.0f + this.amps * AMPS_SPEED_MULTIPLIER);
        this.createdTime = world.getGameTime();
    }

    public void bindDepot(BlockPos depotPos) {
        this.boundDepotPos = depotPos;
    }

    public ArcaneHammerEntity(EntityType<ArcaneHammerEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.playWorldSound((SoundEvent)SoundRegistry.OBLITERATE_CHARGE.get(), 0.75f, this.speed);
        this.playWorldSound((SoundEvent)SoundRegistry.OBLITERATE_CHARGE_LARGE.get(), this.getLargeSoundVolume(), this.speed);
        this.createdTime = this.world.getGameTime();
    }

    private void playWorldSound(SoundEvent soundEvent, float volume, float pitch) {
        Vec3 pos = this.getPosition(1.0f);
        this.world.playSound(null, pos.x, pos.y, pos.z, soundEvent, SoundSource.BLOCKS, volume, pitch);
    }

    private float getChargeSpeed() {
        return this.speed * 3.0f;
    }

    private float getLargeSoundVolume() {
        return Math.min(1.0f, this.amps * 0.125f * 0.4f);
    }

    public void tick() {
        float totalElapsedTime;
        if (this.target != null && !this.didObliterate) {
            this.setPos(ArcaneHammerEntity.getTargetPosition(this.target));
        }
        if ((totalElapsedTime = (float)(this.world.getGameTime() - this.createdTime) / 20.0f) >= UNSCALED_CHARGE_TIME / this.getChargeSpeed() && this.isCharging) {
            this.isCharging = false;
            this.chargedTime = this.world.getGameTime();
            if (this.world.isClientSide) {
                this.setAnimationSpeed(1.0f);
            }
            this.playWorldSound((SoundEvent)SoundRegistry.OBLITERATE_SWING.get(), 1.0f, 1.0f);
        }
        if (!this.isCharging) {
            float elapsedPostChargeTime = (float)(this.world.getGameTime() - this.chargedTime) / 20.0f;
            if (elapsedPostChargeTime >= UNSCALED_TIME_TILL_OBLITERATE && !this.didObliterate && !this.world.isClientSide) {
                this.obliterate();
            }
            if (elapsedPostChargeTime >= UNSCALED_TIME_TILL_DISCARD) {
                this.discard();
            }
        }
    }

    protected void obliterate() {
        if (this.target != null) {
            if (!this.processItems) {
                Entity entity;
                Witch witch;
                DamageSource damageSource = this.getDamageSource();
                this.target.hurt(damageSource, this.getDamage());
                Entity entity2 = this.target;
                if (entity2 instanceof Witch && (witch = (Witch)entity2).getHealth() <= 0.0f && this.caster != null && (entity = this.caster) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    this.triggerAdvancement(serverPlayer);
                }
            }
            if (this.resolver != null) {
                this.resolver.onResolveEffect(this.world, (HitResult)new EntityHitResult(this.target));
            }
        } else {
            Vec3 pos = this.getPosition(1.0f).add(-1.0, -1.0, -1.0);
            BlockPos blockPos = new BlockPos((int)Math.round(pos.x), (int)Math.round(pos.y), (int)Math.round(pos.z));
            if (this.resolver != null) {
                this.resolver.onResolveEffect(this.world, (HitResult)new BlockHitResult(pos, Direction.UP, blockPos, false));
            }
        }
        this.playWorldSound((SoundEvent)SoundRegistry.OBLITERATE_SMASH.get(), 0.75f, 1.0f);
        this.playWorldSound((SoundEvent)SoundRegistry.OBLITERATE_SHOCKWAVE.get(), this.getLargeSoundVolume(), 1.0f);
        this.didObliterate = true;
        this.handleItems();
    }

    private void triggerAdvancement(ServerPlayer player) {
    }

    protected float getDamage() {
        float ampsDamage = this.ampScalar * this.amps;
        float focusDamage = SpellResolverHelpers.shouldDoubleOutputs(this.resolver) ? ampsDamage : 0.0f;
        return 5.0f + ampsDamage + focusDamage;
    }

    protected void handleItems() {
        if (this.boundDepotPos != null) {
            this.handleDepotItems();
            return;
        }
        List itemEntities = this.world.getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0));
        if (itemEntities.isEmpty()) {
            return;
        }
        Vec3 midPoint = itemEntities.stream().map(Entity::position).reduce(Vec3.ZERO, Vec3::add).scale(1.0 / (double)itemEntities.size());
        if (this.processItems) {
            this.processItems(itemEntities);
            this.sendProcessingParticles(midPoint);
        } else {
            itemEntities.forEach(Entity::discard);
        }
    }

    private void handleDepotItems() {
        if (!this.processItems) {
            return;
        }
        BlockEntity be = this.world.getBlockEntity(this.boundDepotPos);
        if (be == null) {
            return;
        }
        BlockState bs = be.getBlockState();
        IItemHandler itemHandler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.world, this.boundDepotPos, bs, be, null);
        if (itemHandler == null) {
            return;
        }
        Vec3 hammerPos = this.getPosition(1.0f);
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            Optional<ProcessingRecipe> recipe;
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.isEmpty() || (recipe = RecipeHelpers.getCrushingRecipeForItemStack(stack, this.world)).isEmpty()) continue;
            int count = stack.getCount();
            itemHandler.extractItem(slot, count, false);
            boolean allowOverflow = SpellResolverHelpers.shouldDoubleOutputs(this.resolver);
            int fortuneLevel = 0;
            if (this.spellStats != null) {
                fortuneLevel = this.spellStats.getBuffCount((AbstractAugment)AugmentFortune.INSTANCE);
            }
            float chanceMultiplier = ObliterateHelper.getFortuneChanceMultiplier(fortuneLevel);
            if (allowOverflow) {
                chanceMultiplier *= 2.0f;
            }
            ArrayList allResults = new ArrayList();
            for (int i = 0; i < count; ++i) {
                List<ItemStack> rolledResults = RecipeHelpers.rollResultsWithFortuneBoost(recipe.get(), this.world.getRandom(), chanceMultiplier, allowOverflow);
                for (ItemStack result : rolledResults) {
                    ItemHelper.addToList((ItemStack)result, allResults);
                }
            }
            for (ItemStack result : allResults) {
                ItemEntity resultEntity = new ItemEntity(this.world, hammerPos.x, hammerPos.y, hammerPos.z, result);
                resultEntity.setDeltaMovement(Vec3.ZERO);
                resultEntity.setPickUpDelay(10);
                this.world.addFreshEntity((Entity)resultEntity);
            }
            this.sendProcessingParticles(hammerPos);
        }
    }

    private void processItems(List<ItemEntity> itemEntities) {
        itemEntities.forEach(itemEntity -> {
            ItemStack itemStack = itemEntity.getItem();
            Optional<ProcessingRecipe> recipe = RecipeHelpers.getCrushingRecipeForItemStack(itemStack, this.world);
            ArrayList list = new ArrayList();
            if (recipe.isPresent()) {
                int rolls = itemStack.getCount();
                boolean allowOverflow = SpellResolverHelpers.shouldDoubleOutputs(this.resolver);
                int fortuneLevel = 0;
                if (this.spellStats != null) {
                    fortuneLevel = this.spellStats.getBuffCount((AbstractAugment)AugmentFortune.INSTANCE);
                }
                float chanceMultiplier = ObliterateHelper.getFortuneChanceMultiplier(fortuneLevel);
                if (allowOverflow) {
                    chanceMultiplier *= 2.0f;
                }
                for (int roll = 0; roll < rolls; ++roll) {
                    List<ItemStack> rolledResults = RecipeHelpers.rollResultsWithFortuneBoost(recipe.get(), this.world.getRandom(), chanceMultiplier, allowOverflow);
                    for (ItemStack stack : rolledResults) {
                        ItemHelper.addToList((ItemStack)stack, list);
                    }
                }
                list.forEach(result -> {
                    ItemEntity resultEntity = new ItemEntity(this.world, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), result);
                    this.world.addFreshEntity((Entity)resultEntity);
                });
                itemEntity.discard();
            }
        });
    }

    protected DamageSource getDamageSource() {
        Holder.Reference magicDamageType = this.world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.GENERIC);
        DamageSource hammerDamageSource = new DamageSource((Holder)magicDamageType, (Entity)this, this.caster);
        return hammerDamageSource;
    }

    private void sendProcessingParticles(Vec3 position) {
        Vec3 finalPos;
        int i;
        for (i = 0; i < 10; ++i) {
            finalPos = position.add(Math.random(), 0.25, Math.random());
            ParticleEffectPacket.send(this.world, ParticleColor.fromInt((int)this.color.getColor()), ParticleTypes.DUST, finalPos);
        }
        for (i = 0; i < 8; ++i) {
            finalPos = position.add(Math.random() / 2.0, 0.0, Math.random() / 2.0);
            ParticleEffectPacket.send(this.world, ParticleColor.fromInt((int)this.color.getColor()), (ParticleType)ParticleRegistry.SPIRAL_DUST_TYPE.get(), finalPos);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        this.animationController = new AnimationController((GeoAnimatable)this, "hammerController", 0, this::smashAnimationPredicate);
        this.animationController.setCustomInstructionKeyframeHandler(event -> {
            CustomInstructionKeyframeData keyframeData = event.getKeyframeData();
            String instructions = keyframeData.getInstructions();
            if (instructions != null) {
                String[] instructionList;
                for (String instruction : instructionList = instructions.split(";")) {
                    if (!(instruction = instruction.trim()).startsWith("alpha=")) continue;
                    String[] parts = instruction.split("=");
                    this.setAlpha(Float.parseFloat(parts[1]));
                }
            }
        });
        controllerRegistrar.add(this.animationController);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState smashAnimationPredicate(AnimationState<?> event) {
        if (!this.isCharging) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("smash"));
            return PlayState.CONTINUE;
        }
        if (!this.chargeAnimationPlayed) {
            this.setAnimationSpeed(this.getChargeSpeed());
            event.getController().setAnimation(RawAnimation.begin().thenPlay("charge"));
            this.chargeAnimationPlayed = true;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    private void setAnimationSpeed(float speed) {
        if (this.animationController != null) {
            this.animationController.setAnimationSpeed((double)speed);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder dataBuilder) {
        dataBuilder.define(COLOR, (Object)0);
        dataBuilder.define(YAW, (Object)Float.valueOf(0.0f));
        dataBuilder.define(SIZE, (Object)Float.valueOf(1.0f));
        dataBuilder.define(ALPHA, (Object)Float.valueOf(0.0f));
        dataBuilder.define(SPEED, (Object)Float.valueOf(1.0f));
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (COLOR.equals(key)) {
            this.color = new Color(((Integer)this.entityData.get(COLOR)).intValue());
        }
        if (YAW.equals(key)) {
            this.yaw = ((Float)this.entityData.get(YAW)).floatValue();
        }
        if (SIZE.equals(key)) {
            this.size = ((Float)this.entityData.get(SIZE)).floatValue();
        }
        if (ALPHA.equals(key)) {
            this.alpha = ((Float)this.entityData.get(ALPHA)).floatValue();
        }
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.entityData.get(SPEED)).floatValue();
        }
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
    }
}

