/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.content.schematics.cannon.SchematicannonRenderer;
import com.zeroregard.ars_technica.api.ITechnomancerAware;
import com.zeroregard.ars_technica.client.block.AllPartialModels;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ArcaneSchematiccannonRenderer
extends SchematicannonRenderer {
    private static float accumulatedTime = 0.0f;

    public ArcaneSchematiccannonRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ITechnomancerAware technomancerAware;
        super.renderSafe(blockEntity, partialTicks, ms, buffer, light, overlay);
        if (blockEntity instanceof ITechnomancerAware && (technomancerAware = (ITechnomancerAware)blockEntity).isTechnomancerNearby()) {
            accumulatedTime += (float)Minecraft.getInstance().getFrameTimeNs() / 1.0E9f;
            this.renderCannonModel(blockEntity, partialTicks, ms, buffer, light, overlay);
        }
    }

    private void renderCannonModel(SchematicannonBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = blockEntity.getBlockState();
        BlockPos pos = blockEntity.getBlockPos();
        double[] cannonAngles = ArcaneSchematiccannonRenderer.getCannonAngles((SchematicannonBlockEntity)blockEntity, (BlockPos)pos, (float)partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = ArcaneSchematiccannonRenderer.getRecoil((SchematicannonBlockEntity)blockEntity, (float)partialTicks);
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        double distSq = camPos.distanceToSqr(Vec3.atCenterOf((Vec3i)pos));
        double distance = Math.sqrt(distSq);
        float alpha = 1.0f;
        if (distance > 4.0) {
            alpha = (float)Mth.clamp((double)(1.0 - (distance - 4.0) / 4.0), (double)0.0, (double)1.0);
        }
        int alphaInt = Math.round(255.0f * alpha);
        ms.pushPose();
        double translateX = 0.5 + 0.005 * Math.sin(accumulatedTime * 30.0f);
        double translateZ = 0.5 + 0.005 * Math.cos(accumulatedTime * 30.0f);
        SuperByteBuffer pipe = CachedBuffers.partial((PartialModel)AllPartialModels.ARCANE_PIPE, (BlockState)state);
        pipe.translate(0.5f, 0.9375f, 0.5f);
        pipe.scale(1.05f);
        pipe.rotate((float)((yaw + 90.0) / 180.0 * Math.PI), Direction.UP);
        pipe.rotate((float)(pitch / 180.0 * Math.PI), Direction.SOUTH);
        pipe.translate(-translateX, -0.9375, -translateZ);
        pipe.translate(0.0, -recoil / 100.0, 0.0);
        pipe.light(0xF000F0).color(255, 255, 255, alphaInt).renderInto(ms, buffer.getBuffer(RenderType.translucentMovingBlock()));
        ms.popPose();
    }
}

